/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.configuration;

import com.bizunited.platform.rbac.security.starter.handle.SimpleAccessDeniedHandler;
import com.bizunited.platform.rbac.security.starter.handle.SimpleAuthenticationFailureHandler;
import com.bizunited.platform.rbac.security.starter.handle.SimpleAuthenticationSuccessHandler;
import com.bizunited.platform.rbac.security.starter.service.security.CustomAccessDecisionManager;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterInvocationSecurityMetadataSource;
import com.bizunited.platform.rbac.security.starter.service.security.CustomFilterSecurityInterceptor;
import com.bizunited.platform.rbac.security.starter.service.security.CustomUserSecurityDetailsService;
import com.bizunited.platform.rbac.security.starter.service.security.SimpleAuthenticationDetailsSource;
import com.bizunited.platform.rbac.security.starter.service.security.SimpleAuthenticationProvider;
import com.bizunited.platform.rbac.server.configuration.NebulaWebSecurityConfigurerAdapter;
import com.bizunited.platform.rbac.server.crypto.password.Aes2PasswordEncoder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableAutoConfiguration
@EnableWebSecurity
@ComponentScan(basePackages={"com.bizunited.platform.rbac.security.starter", "com.bizunited.platform.rbac.server", "com.bizunited.platform.core"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${rbac.ignoreUrls}")
    private String[] ignoreUrls;
    @Value(value="${rbac.loginUrl}")
    private String loginUrl;
    @Value(value="${rbac.loginPageUrl:}")
    private String loginPageUrl;
    @Value(value="${rbac.logoutUrl}")
    private String logoutUrl;
    @Value(value="${rbac.logoutSuccessRedirect:}")
    private String logoutSuccessRedirect;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    private AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    private LogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    private AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> authenticationDetailsSource;
    @Autowired
    private AccessDecisionManager accessDecisionManager;
    @Autowired
    private SimpleAuthenticationProvider authenticationProvider;
    @Autowired
    private FilterInvocationSecurityMetadataSource securityMetadataSource;
    @Autowired(required=false)
    private NebulaWebSecurityConfigurerAdapter nebulaWebSecurityConfigurerAdapter;
    public static final String[] DEFAULT_IGNOREURLS = new String[]{"/default/**", "/static/**", "/v1/kuiper/templatevisibilities/findDetailsByTemplateId", "/v1/kuiper/templates/findByConditions", "/v1/nebula/checkCodes", "/v1/nebula/validateCodes"};

    protected void configure(HttpSecurity http) throws Exception {
        CustomFilterSecurityInterceptor filterSecurityInterceptor = new CustomFilterSecurityInterceptor(this.securityMetadataSource, this.accessDecisionManager, super.authenticationManager());
        CorsConfigurationSource configurationSource = this.corsConfigurationSource();
        SimpleAccessDeniedHandler simpleAccessDeniedHandler = new SimpleAccessDeniedHandler(this);
        ArrayList<String> currentIgnoreUrls = new ArrayList<String>();
        if (this.ignoreUrls != null && this.ignoreUrls.length > 0) {
            currentIgnoreUrls.addAll(Lists.newArrayList((Object[])this.ignoreUrls));
        }
        currentIgnoreUrls.addAll(Lists.newArrayList((Object[])DEFAULT_IGNOREURLS));
        if (StringUtils.isNotBlank((CharSequence)this.logoutSuccessRedirect)) {
            currentIgnoreUrls.add(this.logoutSuccessRedirect);
        }
        if (StringUtils.isNotBlank((CharSequence)this.loginPageUrl)) {
            currentIgnoreUrls.add(this.loginPageUrl);
        }
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.addFilterAt((Filter)filterSecurityInterceptor, FilterSecurityInterceptor.class).cors().configurationSource(configurationSource).and()).headers().frameOptions().disable().and()).sessionManagement().enableSessionUrlRewriting(true).and()).authorizeRequests().requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll().antMatchers(currentIgnoreUrls.toArray(new String[0]))).permitAll().anyRequest()).authenticated().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)simpleAccessDeniedHandler).accessDeniedHandler((AccessDeniedHandler)simpleAccessDeniedHandler).and()).formLogin().loginPage("/v1/rbac/loginFail").loginProcessingUrl(this.loginUrl)).successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler)).authenticationDetailsSource(this.authenticationDetailsSource)).permitAll()).and()).logout().logoutUrl(this.logoutUrl).logoutSuccessHandler(this.logoutSuccessHandler).permitAll().and()).csrf().disable()).rememberMe().tokenValiditySeconds(8640000).rememberMeCookieName("persistence").alwaysRemember(true);
        if (this.nebulaWebSecurityConfigurerAdapter != null) {
            this.nebulaWebSecurityConfigurerAdapter.configure(http);
        }
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder());
    }

    @Bean(value={"simpleAuthenticationSuccessHandler"})
    @ConditionalOnMissingBean(value={AuthenticationSuccessHandler.class})
    public AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return new SimpleAuthenticationSuccessHandler();
    }

    @Bean(value={"simpleAuthenticationFailureHandler"})
    @ConditionalOnMissingBean(value={AuthenticationFailureHandler.class})
    public AuthenticationFailureHandler getAuthenticationFailureHandler() {
        return new SimpleAuthenticationFailureHandler();
    }

    @Bean(name={"customUserSecurityDetailsService"})
    @ConditionalOnMissingBean(value={UserDetailsService.class})
    public UserDetailsService getUserDetailsService() {
        return new CustomUserSecurityDetailsService();
    }

    @Bean(name={"passwordEncoder"})
    @ConditionalOnMissingBean(value={PasswordEncoder.class})
    public PasswordEncoder passwordEncoder() {
        return new Pbkdf2PasswordEncoder();
    }

    @Bean(name={"aes2PasswordEncoder"})
    @ConditionalOnMissingBean(value={Aes2PasswordEncoder.class})
    public Aes2PasswordEncoder aes2PasswordEncoder() {
        return new Aes2PasswordEncoder();
    }

    @Bean(name={"customAccessDecisionManager"})
    @ConditionalOnMissingBean(value={AccessDecisionManager.class})
    public AccessDecisionManager getCustomAccessDecisionManager() {
        return new CustomAccessDecisionManager();
    }

    @Bean(name={"customFilterInvocationSecurityMetadataSource"})
    @ConditionalOnMissingBean(value={FilterInvocationSecurityMetadataSource.class})
    public FilterInvocationSecurityMetadataSource getCustomFilterInvocationSecurityMetadataSource() {
        return new CustomFilterInvocationSecurityMetadataSource();
    }

    @Bean(name={"authenticationDetailsSource"})
    @ConditionalOnMissingBean(value={AuthenticationDetailsSource.class})
    public AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> getAuthenticationDetailsSource() {
        return new SimpleAuthenticationDetailsSource();
    }

    public String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public String getLogoutSuccessRedirect() {
        return this.logoutSuccessRedirect;
    }

    private CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

