package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import com.bizunited.platform.rbac.security.starter.service.security.LoginDetails;
import com.bizunited.platform.user.common.vo.UserVo;
import org.springframework.stereotype.Component;

/**
 * 手机号 + 短信验证码的登录鉴权方式
 * @author yinwenjie
 */
@Component("simplePhoneAndSmsCodeDecision")
public class SimplePhoneAndSmsCodeDecision extends AbstractAuthenticationDecision {

  @Override
  public UserVo authenticate(LoginDetails loginDetails) {
    /*
     * .处理过程如下：
     * 1、首先通过手机号、查询当前用户的存在性
     * 2、然后判断当前用户的短信验证码是否正确
     * */
    // 1、=====
    String phone = loginDetails.getPhone();
    UserVo currentUser = super.validatePhone(phone);
    // 2、=====
    String sessionId = loginDetails.getSessionId();
    String smsVerificationCode = loginDetails.getSmsVerificationCode();
    super.validateSmsVerificationCode(sessionId, smsVerificationCode);
    
    return currentUser;
  }

  @Override
  public DecisionTypes type() {
    return DecisionTypes.PHONEANDSMSCODE;
  }
}