/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import com.bizunited.platform.rbac.security.starter.service.security.authenticate.AuthenticationDecision;
import com.bizunited.platform.rbac.server.service.ccode.CheckCodeService;
import com.bizunited.platform.rbac.server.service.vcode.ValidateCodeService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.password.PasswordEncoder;

public abstract class AbstractAuthenticationDecision
implements AuthenticationDecision {
    protected static final String LOG_SUBSYSTEM = "login";
    @Autowired
    @Qualifier(value="passwordEncoder")
    @Lazy
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UserService userService;
    @Autowired
    private ValidateCodeService validateCodeService;
    @Autowired
    private CheckCodeService checkCodeService;

    protected UserVo validateUserNameAndPassword(String userName, String inputPassword) {
        Validate.notBlank((CharSequence)inputPassword, (String)"\u5bc6\u7801\u4fe1\u606f\u5fc5\u987b\u586b\u5199\uff01\uff01", (Object[])new Object[0]);
        UserVo currentUser = this.validateUserName(userName);
        String currentPassword = currentUser.getPassword();
        Validate.isTrue((boolean)this.passwordEncoder.matches((CharSequence)inputPassword, currentPassword), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        return currentUser;
    }

    protected UserVo validatePhoneAndPassword(String phone, String inputPassword) {
        Validate.notBlank((CharSequence)inputPassword, (String)"\u5bc6\u7801\u4fe1\u606f\u5fc5\u987b\u586b\u5199\uff01\uff01", (Object[])new Object[0]);
        UserVo currentUser = this.validatePhone(phone);
        String currentPassword = currentUser.getPassword();
        Validate.isTrue((boolean)this.passwordEncoder.matches((CharSequence)inputPassword, currentPassword), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        return currentUser;
    }

    protected UserVo validateUserName(String userName) {
        Validate.notBlank((CharSequence)userName, (String)"\u7528\u6237\u540d\u4fe1\u606f\u5fc5\u987b\u586b\u5199\uff01\uff01", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByAccount(userName);
        Validate.notNull((Object)currentUser, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((currentUser.getUseStatus() == 1 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        return currentUser;
    }

    protected UserVo validatePhone(String phone) {
        Validate.notBlank((CharSequence)phone, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByPhone(phone);
        Validate.notNull((Object)currentUser, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((currentUser.getUseStatus() == 1 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        return currentUser;
    }

    protected void validateSmsVerificationCode(String sessionId, String smsVerificationCode) {
        Validate.notBlank((CharSequence)sessionId, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)smsVerificationCode, (String)"\u7528\u6237\u5fc5\u987b\u8f93\u5165\u6536\u5230\u7684\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4fe1\u606f\uff01\uff01", (Object[])new Object[0]);
        boolean isMatch = this.validateCodeService.match(sessionId, LOG_SUBSYSTEM, smsVerificationCode);
        Validate.isTrue((boolean)isMatch, (String)"\u7528\u6237\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\uff08\u91cd\u53d1\uff09\uff01\uff01", (Object[])new Object[0]);
    }

    protected void validateCheckCode(String sessionId, String checkCode) {
        Validate.notBlank((CharSequence)sessionId, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\uff0c\u6216\u8005\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e5f\u53ef\u80fd\u662f\u5bc6\u7801\u5df2\u7ecf\u5931\u6548\uff01\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)checkCode, (String)"\u7528\u6237\u5fc5\u987b\u8f93\u5165\u6821\u9a8c\u7801\uff0c\u4e00\u822c\u5b83\u4ee5\u56fe\u7247\u7684\u65b9\u5f0f\u5448\u73b0\u7ed9\u7528\u6237\uff01\uff01", (Object[])new Object[0]);
        boolean isMatch = this.checkCodeService.match(sessionId, checkCode);
        Validate.isTrue((boolean)isMatch, (String)"\u7528\u6237\u8f93\u5165\u7684\u56fe\u5f62\u6821\u9a8c\u7801\u9519\u8bef\uff0c\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
    }
}

