package com.bizunited.platform.rbac.security.starter.service.security.authenticate;

import com.bizunited.platform.rbac.security.starter.service.security.LoginDetails;
import com.bizunited.platform.user.common.vo.UserVo;

/**
 * 鉴权决策器，目前支持六种
 * @author yinwenjie
 *
 */
public interface AuthenticationDecision {
  String ERROR_USER = "没有发现指定的用户，或者用户已经被禁用，也可能是密码已经失效！！";
  String ERROR_SMS_CODE = "用户输入的验证码错误，或已失效，请检查（重发）！！";
  String ERROR_CHECK_CODE = "用户输入的图形校验码错误，或已失效，请检查！！";
  /**
   * 用户登录信息角色器
   * @param loginDetails 当前登录的用户信息 
   * @return 如果鉴权成功，则返回用户基本信息（也就是说不必包括用户当前的权限信息），但是这个用户必须有ID
   */
  public UserVo authenticate(LoginDetails loginDetails);
  
  /**
   * 该方法返回当前实现的对应的认证类型：</br>
   * 1、典型的用户名+密码方式；</br>
   * 2、典型的用户名 + 密码 + 校验码方式；</br>
   * 3、用户名 + 短信验证码 + 校验码方式；</br> 
   * 4、手机号 + 密码方式；</br>
   * 5、手机号 + 短信验证码；</br>
   * 6、手机号 + 短信验证码 + 校验码方式 
   */
  public DecisionTypes type();
}
