package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 16:10
 * @Description: 流程缓存,可用于缓存流程信息的json数据等
 */
@ApiModel(value = "ProcessCacheEntity", description = "流程缓存")
@Entity
@Table(name = "engine_process_cache")
@org.hibernate.annotations.Table(appliesTo = "engine_process_cache" , comment = "流程缓存")
public class ProcessCacheEntity extends UuidEntity {
  private static final long serialVersionUID = -590067828993222891L;
  /**
   * 缓存key
   */
  @ApiModelProperty(name = "cacheKey", value = "缓存key", required = true)
  @Column(name = "cache_key", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '缓存key'")
  @SaturnColumn(description = "缓存key")
  private String cacheKey;
  /**
   * 缓存信息
   */
  @ApiModelProperty(name = "cacheInfo", value = "缓存信息", required = true)
  @Column(name = "cache_info", length = 1024, nullable = false, columnDefinition = "varchar(1024) COMMENT '缓存信息'")
  @SaturnColumn(description = "缓存信息")
  private String cacheInfo;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;

  public String getCacheKey() {
    return cacheKey;
  }

  public void setCacheKey(String cacheKey) {
    this.cacheKey = cacheKey;
  }

  public String getCacheInfo() {
    return cacheInfo;
  }

  public void setCacheInfo(String cacheInfo) {
    this.cacheInfo = cacheInfo;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
