package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 16:17
 * @Description: 流程转发记录，单独用于流程的转发记录，有未读和已读的状态
 */
@ApiModel(value = "ProcessCarbonCopyEntity", description = "流程转发记录")
@Entity
@Table(name = "engine_process_carbon_copy")
@org.hibernate.annotations.Table(appliesTo = "engine_process_carbon_copy" , comment = "流程转发记录")
public class ProcessCarbonCopyEntity extends UuidEntity {
  private static final long serialVersionUID = -3294287953360984228L;
  /**
   * 流程实例
   */
  @ApiModelProperty(name = "processInstance", value = "流程实例", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_instance", nullable = false, columnDefinition = "varchar(255) COMMENT '流程实例'")
  @SaturnColumn(description = "流程实例")
  private ProcessInstanceEntity processInstance;
  /**
   * 任务ID
   */
  @ApiModelProperty(name = "taskId", value = "任务ID", required = true)
  @Column(name = "task_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '任务ID'")
  @SaturnColumn(description = "任务ID")
  private String taskId;
  /**
   * 任务定义ID
   */
  @ApiModelProperty(name = "taskDefId", value = "任务定义ID", required = true)
  @Column(name = "task_def_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '任务定义ID'")
  @SaturnColumn(description = "任务定义ID")
  private String taskDefId;
  /**
   * 抄送人
   */
  @ApiModelProperty(name = "ccUser", value = "抄送人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "cc_user", nullable = false, columnDefinition = "varchar(255) COMMENT '抄送人'")
  @SaturnColumn(description = "抄送人")
  private UserEntity ccUser;
  /**
   * 接收人
   */
  @ApiModelProperty(name = "receiveAssignment", value = "接收人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "receive_assignment", columnDefinition = "varchar(255) COMMENT '接收人'")
  @SaturnColumn(description = "接收人")
  private ProcessAssignmentEntity receiveAssignment;
  /**
   * 状态：0=未读，1=已读
   */
  @ApiModelProperty(name = "state", value = "状态：0=未读，1=已读", required = true)
  @Column(name = "state", nullable = false, columnDefinition = "int(11) COMMENT '状态：0=未读，1=已读'")
  @SaturnColumn(description = "状态：0=未读，1=已读")
  private Integer state;
  /**
   * 阅读时间
   */
  @ApiModelProperty(name = "readTime", value = "阅读时间")
  @Column(name = "read_time", columnDefinition = "datetime COMMENT '阅读时间'")
  @SaturnColumn(description = "阅读时间")
  private Date readTime;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  public ProcessInstanceEntity getProcessInstance() {
    return processInstance;
  }

  public void setProcessInstance(ProcessInstanceEntity processInstance) {
    this.processInstance = processInstance;
  }

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getTaskDefId() {
    return taskDefId;
  }

  public void setTaskDefId(String taskDefId) {
    this.taskDefId = taskDefId;
  }

  public UserEntity getCcUser() {
    return ccUser;
  }

  public void setCcUser(UserEntity ccUser) {
    this.ccUser = ccUser;
  }

  public ProcessAssignmentEntity getReceiveAssignment() {
    return receiveAssignment;
  }

  public void setReceiveAssignment(ProcessAssignmentEntity receiveAssignment) {
    this.receiveAssignment = receiveAssignment;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public Date getReadTime() {
    return readTime;
  }

  public void setReadTime(Date readTime) {
    this.readTime = readTime;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
