package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 15:23
 * @Description: 流程检测记录明细
 */
@ApiModel(value = "ProcessCheckRecordItemEntity", description = "流程检测记录明细")
@Entity
@Table(name = "engine_process_check_record_item")
@org.hibernate.annotations.Table(appliesTo = "engine_process_check_record_item" , comment = "流程检测记录明细")
public class ProcessCheckRecordItemEntity extends UuidEntity {
  private static final long serialVersionUID = 8068329125659186546L;
  /**
   * 流程检测记录
   */
  @ApiModelProperty(name = "processCheckRecord", value = "流程检测记录", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_check_record", nullable = false, columnDefinition = "varchar(255) COMMENT '流程检测记录'")
  @SaturnColumn(description = "流程检测记录")
  private ProcessCheckRecordEntity processCheckRecord;
  /**
   * 节点名
   */
  @ApiModelProperty(name = "nodeKey", value = "节点名", required = true)
  @Column(name = "node_key", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '节点名'")
  @SaturnColumn(description = "节点名")
  private String nodeKey;
  /**
   * 节点名称
   */
  @ApiModelProperty(name = "nodeName", value = "节点名称", required = true)
  @Column(name = "node_name", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '节点名称'")
  @SaturnColumn(description = "节点名称")
  private String nodeName;
  /**
   * 任务ID
   */
  @ApiModelProperty(name = "taskId", value = "任务ID", required = true)
  @Column(name = "task_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '任务ID'")
  @SaturnColumn(description = "任务ID")
  private String taskId;
  /**
   * 结果
   */
  @ApiModelProperty(name = "result", value = "结果", required = true)
  @Column(name = "result", length = 512, nullable = false, columnDefinition = "varchar(512) COMMENT '结果'")
  @SaturnColumn(description = "结果")
  private String result;
  /**
   * 状态（0未完成，1成功，2失败）
   */
  @ApiModelProperty(name = "state", value = "状态（0未完成，1成功，2失败）", required = true)
  @Column(name = "state", nullable = false, columnDefinition = "int(11) COMMENT '状态（0未完成，1成功，2失败）'")
  @SaturnColumn(description = "状态（0未完成，1成功，2失败）")
  private Integer state;
  /**
   * 检测类型,PASS
   */
  @ApiModelProperty(name = "checkType", value = "检测类型,PASS", required = true)
  @Column(name = "check_type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '检测类型,PASS'")
  @SaturnColumn(description = "检测类型,PASS")
  private String checkType;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '标题'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  public ProcessCheckRecordEntity getProcessCheckRecord() {
    return processCheckRecord;
  }

  public void setProcessCheckRecord(ProcessCheckRecordEntity processCheckRecord) {
    this.processCheckRecord = processCheckRecord;
  }

  public String getNodeKey() {
    return nodeKey;
  }

  public void setNodeKey(String nodeKey) {
    this.nodeKey = nodeKey;
  }

  public String getNodeName() {
    return nodeName;
  }

  public void setNodeName(String nodeName) {
    this.nodeName = nodeName;
  }

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getCheckType() {
    return checkType;
  }

  public void setCheckType(String checkType) {
    this.checkType = checkType;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
