package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 15:46
 * @Description: 流程实例附件,保存流程实例在流程过程中审批人上传的附件
 */
@ApiModel(value = "ProcessInstanceAttachmentEntity", description = "流程实例附件")
@Entity
@Table(name = "engine_process_instance_attachment")
@org.hibernate.annotations.Table(appliesTo = "engine_process_instance_attachment" , comment = "流程实例附件")
public class ProcessInstanceAttachmentEntity extends UuidEntity {

  private static final long serialVersionUID = 4745401102263927693L;
  /**
   * 流程实例
   */
  @ApiModelProperty(name = "processInstance", value = "流程实例", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_instance", nullable = false, columnDefinition = "varchar(255) COMMENT '流程实例'")
  @SaturnColumn(description = "流程实例")
  private ProcessInstanceEntity processInstance;
  /** 文件的目录 */
  @ApiModelProperty(name = "fileCode", value = "文件的目录", required = true)
  @Column(name = "file_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '文件的目录'")
  @SaturnColumn(description = "文件的目录")
  private String fileCode;
  /** 源文件名 */
  @ApiModelProperty(name = "fileName", value = "文件名", required = true)
  @Column(name = "file_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '文件名'")
  @SaturnColumn(description = "文件名")
  private String fileName;
  /** 文件名 */
  @ApiModelProperty(name = "fileRename", value = "文件名", required = true)
  @Column(name = "file_rename", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '文件名'")
  @SaturnColumn(description = "文件名")
  private String fileRename;
  /**
   * 创建人
   */
  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "create_user", nullable = false, columnDefinition = "varchar(255) COMMENT '创建人'")
  @SaturnColumn(description = "创建人")
  private UserEntity createUser;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  public ProcessInstanceEntity getProcessInstance() {
    return processInstance;
  }

  public void setProcessInstance(ProcessInstanceEntity processInstance) {
    this.processInstance = processInstance;
  }

  public UserEntity getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserEntity createUser) {
    this.createUser = createUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getFileCode() {
    return fileCode;
  }

  public void setFileCode(String fileCode) {
    this.fileCode = fileCode;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getFileRename() {
    return fileRename;
  }

  public void setFileRename(String fileRename) {
    this.fileRename = fileRename;
  }

}
