package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 15:34
 * @Description: 流程实例
 */
@ApiModel(value = "ProcessInstanceEntity", description = "流程实例")
@Entity
@Table(name = "engine_process_instance")
@org.hibernate.annotations.Table(appliesTo = "engine_process_instance" , comment = "流程实例")
public class ProcessInstanceEntity extends UuidEntity {
  private static final long serialVersionUID = 1516062571884629569L;
  /**
   * 流程实例ID
   */
  @ApiModelProperty(name = "processInstanceId", value = "流程实例ID", required = true)
  @Column(name = "process_instance_id", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '流程实例ID'")
  @SaturnColumn(description = "流程实例ID")
  private String processInstanceId;
  /**
   * 流程模版
   */
  @ApiModelProperty(name = "processTemplate", value = "流程模版", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template", nullable = false, columnDefinition = "varchar(255) COMMENT '流程模版'")
  @SaturnColumn(description = "流程模版")
  private ProcessTemplateEntity processTemplate;
  /**
   * 表单实例
   */
  @ApiModelProperty(name = "formInstanceId", value = "表单实例")
  @Column(name = "form_instance_id", length = 64, columnDefinition = "varchar(64) COMMENT '表单实例Id'")
  @SaturnColumn(description = "表单实例Id")
  private String formInstanceId;
  /**
   * 表单编号
   */
  @ApiModelProperty(name = "formNo", value = "表单编号")
  @Column(name = "form_no", length = 128, columnDefinition = "varchar(128) COMMENT '表单编号'")
  @SaturnColumn(description = "表单编号")
  private String formNo;
  /**
   * 表单Create实例活动ID
   */
  @ApiModelProperty(name = "formCreateActivityId", value = "表单Create实例活动ID")
  @Column(name = "form_create_activity_id", length = 128, columnDefinition = "varchar(128) COMMENT '表单Create实例活动ID'")
  @SaturnColumn(description = "表单Create实例活动ID")
  private String formCreateActivityId;
  /**
   * 申请人
   */
  @ApiModelProperty(name = "applicantUser", value = "申请人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "applicant_user", nullable = false, columnDefinition = "varchar(255) COMMENT '申请人'")
  @SaturnColumn(description = "申请人")
  private UserEntity applicantUser;
  /**
   * 0=草稿1=审批中2=已完成3=驳回4=终止5=撤销
   */
  @ApiModelProperty(name = "processState", value = "0=草稿1=审批中2=已完成3=驳回4=终止5=撤销", required = true)
  @Column(name = "process_state", nullable = false, columnDefinition = "int(11) COMMENT '0=草稿1=审批中2=已完成3=驳回4=终止5=撤销'")
  @SaturnColumn(description = "0=草稿1=审批中2=已完成3=驳回4=终止5=撤销")
  private Integer processState;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   * 最后提交时间
   */
  @ApiModelProperty(name = "latestSubmitTime", value = "最后提交时间", required = true)
  @Column(name = "latest_submit_time", nullable = false, columnDefinition = "datetime COMMENT '最后提交时间'")
  @SaturnColumn(description = "最后提交时间")
  private Date latestSubmitTime;
  /**
   * 结束时间
   */
  @ApiModelProperty(name = "endTime", value = "结束时间")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '结束时间'")
  @SaturnColumn(description = "结束时间")
  private Date endTime;
  /**
   * 最后任务操作人
   */
  @ApiModelProperty(name = "latestAssignment", value = "最后任务操作人")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "latest_assignment", columnDefinition = "varchar(255) COMMENT '最后任务操作人'")
  @SaturnColumn(description = "最后任务操作人")
  private UserEntity latestAssignment;
  /**
   * 当前任务操作人
   */
  @Transient
  @ApiModelProperty(name = "currentAssignments", value = "当前任务操作人")
  @SaturnColumn(description = "当前任务操作人")
  private Set<ProcessAssignmentEntity> currentAssignments;
  /**
   * 最后操作时间
   */
  @ApiModelProperty(name = "latestOperateTime", value = "最后操作时间")
  @Column(name = "latest_operate_time", columnDefinition = "datetime COMMENT '最后操作时间'")
  @SaturnColumn(description = "最后操作时间")
  private Date latestOperateTime;
  /**
   * 最后任务节点
   */
  @ApiModelProperty(name = "latestNode", value = "最后任务节点")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "latest_node", columnDefinition = "varchar(255) COMMENT '最后任务节点'")
  @SaturnColumn(description = "最后任务节点")
  private ProcessTemplateNodeEntity latestNode;
  /**
   * 当前任务节点
   */
  @ApiModelProperty(name = "currentNodes", value = "当前任务节点")
  @ManyToMany(fetch = FetchType.LAZY, targetEntity = ProcessTemplateNodeEntity.class)
  @JoinTable(
      name = "engine_process_instance_node_mapping",
      joinColumns = {@JoinColumn(name = "process_instance_id")},
      inverseJoinColumns = {@JoinColumn(name = "process_node_id")}
  )
  @SaturnColumn(description = "当前任务节点")
  private Set<ProcessTemplateNodeEntity> currentNodes;
  /**
   * 操作记录
   */
  @ApiModelProperty(name = "records", value = "操作记录")
  @SaturnColumn(description = "操作记录")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "processInstance")
  private Set<ProcessInstanceOperateRecordEntity> records;
  /**
   * 附件
   */
  @ApiModelProperty(name = "attachments", value = "附件")
  @SaturnColumn(description = "附件")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "processInstance")
  private Set<ProcessInstanceAttachmentEntity> attachments;


  public String getProcessInstanceId() {
    return processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public ProcessTemplateEntity getProcessTemplate() {
    return processTemplate;
  }

  public void setProcessTemplate(ProcessTemplateEntity processTemplate) {
    this.processTemplate = processTemplate;
  }

  public String getFormInstanceId() {
    return formInstanceId;
  }

  public void setFormInstanceId(String formInstanceId) {
    this.formInstanceId = formInstanceId;
  }

  public String getFormNo() {
    return formNo;
  }

  public void setFormNo(String formNo) {
    this.formNo = formNo;
  }

  public String getFormCreateActivityId() {
    return formCreateActivityId;
  }

  public void setFormCreateActivityId(String formCreateActivityId) {
    this.formCreateActivityId = formCreateActivityId;
  }

  public UserEntity getApplicantUser() {
    return applicantUser;
  }

  public void setApplicantUser(UserEntity applicantUser) {
    this.applicantUser = applicantUser;
  }

  public Integer getProcessState() {
    return processState;
  }

  public void setProcessState(Integer processState) {
    this.processState = processState;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public Date getLatestSubmitTime() {
    return latestSubmitTime;
  }

  public void setLatestSubmitTime(Date latestSubmitTime) {
    this.latestSubmitTime = latestSubmitTime;
  }

  public UserEntity getLatestAssignment() {
    return latestAssignment;
  }

  public void setLatestAssignment(UserEntity latestAssignment) {
    this.latestAssignment = latestAssignment;
  }

  public Set<ProcessAssignmentEntity> getCurrentAssignments() {
    return currentAssignments;
  }

  public void setCurrentAssignments(Set<ProcessAssignmentEntity> currentAssignments) {
    this.currentAssignments = currentAssignments;
  }

  public Date getLatestOperateTime() {
    return latestOperateTime;
  }

  public void setLatestOperateTime(Date latestOperateTime) {
    this.latestOperateTime = latestOperateTime;
  }

  public ProcessTemplateNodeEntity getLatestNode() {
    return latestNode;
  }

  public void setLatestNode(ProcessTemplateNodeEntity latestNode) {
    this.latestNode = latestNode;
  }

  public Set<ProcessTemplateNodeEntity> getCurrentNodes() {
    return currentNodes;
  }

  public void setCurrentNodes(Set<ProcessTemplateNodeEntity> currentNodes) {
    this.currentNodes = currentNodes;
  }

  public Set<ProcessInstanceOperateRecordEntity> getRecords() {
    return records;
  }

  public void setRecords(Set<ProcessInstanceOperateRecordEntity> records) {
    this.records = records;
  }

  public Date getEndTime() {
    return endTime;
  }

  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }

  public Set<ProcessInstanceAttachmentEntity> getAttachments() {
    return attachments;
  }

  public void setAttachments(Set<ProcessInstanceAttachmentEntity> attachments) {
    this.attachments = attachments;
  }
}
