package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 15:54
 * @Description: 流程实例消息记录
 */
@ApiModel(value = "ProcessInstanceMsgEntity", description = "流程实例消息记录")
@Entity
@Table(name = "engine_process_instance_msg")
@org.hibernate.annotations.Table(appliesTo = "engine_process_instance_msg" , comment = "流程实例消息记录")
public class ProcessInstanceMsgEntity extends UuidEntity {
  private static final long serialVersionUID = 121412189848196281L;
  /**
   * 消息发送人
   */
  @ApiModelProperty(name = "sendUser", value = "消息发送人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "send_user", nullable = false, columnDefinition = "varchar(255) COMMENT '消息发送人'")
  @SaturnColumn(description = "消息发送人")
  private UserEntity sendUser;
  /**
   * 流程实例
   */
  @ApiModelProperty(name = "processInstance", value = "流程实例", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_instance", nullable = false, columnDefinition = "varchar(255) COMMENT '流程实例'")
  @SaturnColumn(description = "流程实例")
  private ProcessInstanceEntity processInstance;
  /**
   * 消息内容
   */
  @ApiModelProperty(name = "content", value = "消息内容", required = true)
  @Column(name = "content", length = 512, nullable = false, columnDefinition = "varchar(512) COMMENT '消息内容'")
  @SaturnColumn(description = "消息内容")
  private String content;
  /**
   * 操作类型
   */
  @ApiModelProperty(name = "operation", value = "操作类型", required = true)
  @Column(name = "operation", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '操作类型'")
  @SaturnColumn(description = "操作类型")
  private String operation;
  /**
   * 父级消息ID
   */
  @ApiModelProperty(name = "parent", value = "父级消息")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "parent", columnDefinition = "varchar(255) COMMENT '父级消息'")
  @SaturnColumn(description = "父级消息")
  private ProcessInstanceMsgEntity parent;
  /**
   * 消息回复
   */
  @ApiModelProperty(name = "replyMsgs", value = "消息回复")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
  @SaturnColumn(description = "消息回复")
  private List<ProcessInstanceMsgEntity> replyMsgs;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  public UserEntity getSendUser() {
    return sendUser;
  }

  public void setSendUser(UserEntity sendUser) {
    this.sendUser = sendUser;
  }

  public ProcessInstanceEntity getProcessInstance() {
    return processInstance;
  }

  public void setProcessInstance(ProcessInstanceEntity processInstance) {
    this.processInstance = processInstance;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public String getOperation() {
    return operation;
  }

  public void setOperation(String operation) {
    this.operation = operation;
  }

  public ProcessInstanceMsgEntity getParent() {
    return parent;
  }

  public void setParent(ProcessInstanceMsgEntity parent) {
    this.parent = parent;
  }

  public List<ProcessInstanceMsgEntity> getReplyMsgs() {
    return replyMsgs;
  }

  public void setReplyMsgs(List<ProcessInstanceMsgEntity> replyMsgs) {
    this.replyMsgs = replyMsgs;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
