package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 16:04
 * @Description: 流程操作记录
 */
@ApiModel(value = "ProcessInstanceOperateRecordEntity", description = "流程操作记录")
@Entity
@Table(name = "engine_process_instance_operate_record")
@org.hibernate.annotations.Table(appliesTo = "engine_process_instance_operate_record" , comment = "流程操作记录")
public class ProcessInstanceOperateRecordEntity extends UuidEntity {
  private static final long serialVersionUID = 5509545946360052952L;
  /**
   * 操作人
   */
  @ApiModelProperty(name = "operator", value = "操作人", required = true)
  @ManyToOne(fetch = FetchType.EAGER, targetEntity = UserEntity.class)
  @JoinColumn(name = "operator", nullable = false, columnDefinition = "varchar(255) COMMENT '操作人'")
  @SaturnColumn(description = "操作人")
  private UserEntity operator;
  /**
   * 操作内容
   */
  @ApiModelProperty(name = "content", value = "操作内容", required = true)
  @Column(name = "content", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '操作内容'")
  @SaturnColumn(description = "操作内容")
  private String content;
  /**
   * 流程实例
   */
  @ApiModelProperty(name = "processInstance", value = "流程实例", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_instance", nullable = false, columnDefinition = "varchar(255) COMMENT '流程实例'")
  @SaturnColumn(description = "流程实例")
  private ProcessInstanceEntity processInstance;
  /**
   * 任务节点
   */
  @ApiModelProperty(name = "processTemplateNode", value = "任务节点", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template_node", nullable = false, columnDefinition = "varchar(255) COMMENT '任务节点'")
  @SaturnColumn(description = "任务节点")
  private ProcessTemplateNodeEntity processTemplateNode;
  /**
   * 任务ID
   */
  @ApiModelProperty(name = "taskId", value = "任务ID", required = true)
  @Column(name = "task_id", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '任务ID'")
  @SaturnColumn(description = "任务ID")
  private String taskId;
  /**
   * 操作类型
   */
  @ApiModelProperty(name = "operation", value = "操作类型", required = true)
  @Column(name = "operation", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '操作类型'")
  @SaturnColumn(description = "操作类型")
  private String operation;
  /**
   * 操作类型说明
   */
  @ApiModelProperty(name = "operationDesc", value = "操作类型说明", required = true)
  @Column(name = "operation_desc", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '操作类型说明'")
  @SaturnColumn(description = "操作类型说明")
  private String operationDesc;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 状态0：未执行，1：已执行
   */
  @Transient
  @ApiModelProperty(name = "createTime", value = "状态0：未执行，1：已执行", required = true)
  @SaturnColumn(description = "状态0：未执行，1：已执行")
  private Integer state = 1;

  public UserEntity getOperator() {
    return operator;
  }

  public void setOperator(UserEntity operator) {
    this.operator = operator;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public ProcessInstanceEntity getProcessInstance() {
    return processInstance;
  }

  public void setProcessInstance(ProcessInstanceEntity processInstance) {
    this.processInstance = processInstance;
  }

  public ProcessTemplateNodeEntity getProcessTemplateNode() {
    return processTemplateNode;
  }

  public void setProcessTemplateNode(ProcessTemplateNodeEntity processTemplateNode) {
    this.processTemplateNode = processTemplateNode;
  }

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getOperation() {
    return operation;
  }

  public void setOperation(String operation) {
    this.operation = operation;
  }

  public String getOperationDesc() {
    return operationDesc;
  }

  public void setOperationDesc(String operationDesc) {
    this.operationDesc = operationDesc;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }
}
