package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 13:50
 * @Description: 流程监听器
 */
@ApiModel(value = "ProcessListenerEntity", description = "流程监听器")
@Entity
@Table(name = "engine_process_listener")
@org.hibernate.annotations.Table(appliesTo = "engine_process_listener" , comment = "流程监听器")
public class ProcessListenerEntity extends UuidEntity {
  private static final long serialVersionUID = -3243353492595907307L;
  /**
   * 事件create,assignment,complete,delete,start,end
   */
  @ApiModelProperty(name = "listenerEvent", value = "事件", required = true)
  @Column(name = "listener_event", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '事件'")
  @SaturnColumn(description = "事件")
  private String listenerEvent;
  /**
   * 监听器名称
   */
  @ApiModelProperty(name = "name", value = "监听器名称", required = true)
  @Column(name = "name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '监听器名称'")
  @SaturnColumn(description = "监听器名称")
  private String name;
  /**
   * 监听器状态：0=禁用，1=启用
   */
  @ApiModelProperty(name = "state", value = "监听器状态：0=禁用，1=启用", required = true)
  @Column(name = "state", nullable = false, columnDefinition = "int(11) COMMENT '监听器状态：0=禁用，1=启用'")
  @SaturnColumn(description = "监听器状态：0=禁用，1=启用")
  private Integer state;
  /**
   * 监听器的类路径
   */
  @ApiModelProperty(name = "listenerClass", value = "监听器的类路径", required = true)
  @Column(name = "listener_class", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '监听器的类路径'")
  @SaturnColumn(description = "监听器的类路径")
  private String listenerClass;
  /**
   * 监听器类型：1=任务监听器，2=执行监听器，3=寻人监听器
   */
  @ApiModelProperty(name = "type", value = "监听器类型：1=任务监听器，2=执行监听器，3=寻人监听器", required = true)
  @Column(name = "type", nullable = false, columnDefinition = "int(11) COMMENT '监听器类型：1=任务监听器，2=执行监听器，3=寻人监听器'")
  @SaturnColumn(description = "监听器类型：1=任务监听器，2=执行监听器，3=寻人监听器")
  private Integer type;
  /**
   * 执行方式：0:原生监听器，1:脚本监听器
   */
  @ApiModelProperty(name = "executeMode", value = "执行方式：0:原生监听器，1:脚本监听器", required = true)
  @Column(name = "execute_mode", nullable = false, columnDefinition = "int(11) COMMENT '执行方式：0:原生监听器，1:脚本监听器'")
  @SaturnColumn(description = "执行方式：0:原生监听器，1:脚本监听器")
  private Integer executeMode;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   * 监听器说明
   */
  @ApiModelProperty(name = "remark", value = "监听器说明")
  @Column(name = "remark", length = 512, columnDefinition = "varchar(512) COMMENT '监听器说明'")
  @SaturnColumn(description = "监听器说明")
  private String remark;

  public String getListenerEvent() {
    return listenerEvent;
  }

  public void setListenerEvent(String listenerEvent) {
    this.listenerEvent = listenerEvent;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getListenerClass() {
    return listenerClass;
  }

  public void setListenerClass(String listenerClass) {
    this.listenerClass = listenerClass;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Integer getExecuteMode() {
    return executeMode;
  }

  public void setExecuteMode(Integer executeMode) {
    this.executeMode = executeMode;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }
}
