package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 11:32
 * @Description: 流程节点审批人配置
 */
@Entity
@ApiModel(value = "ProcessTemplateNodeAssignmentEntity", description = "流程节点审批人配置")
@Table(name = "engine_process_template_node_assignment")
@org.hibernate.annotations.Table(appliesTo = "engine_process_template_node_assignment" , comment = "流程节点审批人配置")
public class ProcessTemplateNodeAssignmentEntity extends UuidEntity {
  private static final long serialVersionUID = -1792880769323292907L;
  /**
   * 审批人类型0=用户，1=表达式，2=监听器，3=职位
   */
  @ApiModelProperty(name = "type", value = "审批人类型0=用户，1=表达式，2=监听器，3=职位", required = true)
  @Column(name = "type", nullable = false, columnDefinition = "int(11) COMMENT '审批人类型0=用户，1=表达式，2=监听器，3=职位'")
  @SaturnColumn(description = "审批人类型0=用户，1=表达式，2=监听器，3=职位")
  private Integer type;
  /**
   * 模版节点
   */
  @ApiModelProperty(name = "processTemplateNode", value = "模版节点", required = true)
  @OneToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template_node", nullable = false, columnDefinition = "varchar(255) COMMENT '模版节点'")
  @SaturnColumn(description = "模版节点")
  private ProcessTemplateNodeEntity processTemplateNode;
  /**
   * 监听器
   */
  @ApiModelProperty(name = "processListener", value = "监听器")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_listener", columnDefinition = "varchar(255) COMMENT '监听器'")
  @SaturnColumn(description = "监听器")
  private ProcessListenerEntity processListener;
  /**
   * 脚本
   */
  @ApiModelProperty(name = "script", value = "脚本")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "script", columnDefinition = "varchar(255) COMMENT '脚本'")
  @SaturnColumn(description = "脚本")
  private ScriptEntity script;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   * 监听器变量
   */
  @Transient
  private Set<ProcessVariableEntity> variables;


  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public Set<ProcessVariableEntity> getVariables() {
    return variables;
  }

  public void setVariables(Set<ProcessVariableEntity> variables) {
    this.variables = variables;
  }

  public ProcessTemplateNodeEntity getProcessTemplateNode() {
    return processTemplateNode;
  }

  public void setProcessTemplateNode(ProcessTemplateNodeEntity processTemplateNode) {
    this.processTemplateNode = processTemplateNode;
  }

  public ProcessListenerEntity getProcessListener() {
    return processListener;
  }

  public void setProcessListener(ProcessListenerEntity processListener) {
    this.processListener = processListener;
  }

  public ScriptEntity getScript() {
    return script;
  }

  public void setScript(ScriptEntity script) {
    this.script = script;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
