package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 11:14
 * @Description: 流程模版节点的定义的编辑器草稿和流程的基础配置
 */
@ApiModel(value = "ProcessTemplateNodeEntity", description = "流程模版节点的定义的编辑器草稿和流程的基础配置")
@Entity
@Table(name = "engine_process_template_node")
@org.hibernate.annotations.Table(appliesTo = "engine_process_template_node" , comment = "流程模版节点的定义的编辑器草稿和流程的基础配置")
public class ProcessTemplateNodeEntity extends UuidEntity {
  private static final long serialVersionUID = 1315101057901414826L;
  /**
   * 流程节点ID
   */
  @ApiModelProperty(name = "processNodeId", value = "流程节点ID", required = true)
  @Column(name = "process_node_id", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '流程节点ID'")
  @SaturnColumn(description = "流程节点ID")
  private String processNodeId;
  /**
   * 流程节点名称
   */
  @ApiModelProperty(name = "processNodeName", value = "流程节点名称", required = true)
  @Column(name = "process_node_name", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '流程节点名称'")
  @SaturnColumn(description = "流程节点名称")
  private String processNodeName;
  /**
   * 流程节点说明
   */
  @ApiModelProperty(name = "processNodeDoc", value = "流程节点说明")
  @Column(name = "process_node_doc", length = 128, columnDefinition = "varchar(128) COMMENT '流程节点说明'")
  @SaturnColumn(description = "流程节点说明")
  private String processNodeDoc;
  /**
   * 流程模版
   */
  @ApiModelProperty(name = "processTemplate", value = "流程模版", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template", nullable = false, columnDefinition = "varchar(255) COMMENT '流程模版'")
  @SaturnColumn(description = "流程模版")
  private ProcessTemplateEntity processTemplate;
  /**
   * 表单可见性
   */
  @ApiModelProperty(name = "formVisibilityName", value = "表单可见性")
  @Column(name = "form_visibility_name", columnDefinition = "varchar(255) COMMENT '表单可见性'")
  @SaturnColumn(description = "表单可见性")
  private String formVisibilityName;
  /**
   * 按钮权限
   */
  @ApiModelProperty(name = "btnAuth", value = "按钮权限")
  @Column(name = "btn_auth", columnDefinition = "varchar(255) COMMENT '按钮权限'")
  @SaturnColumn(description = "按钮权限")
  private String btnAuth;
  /**
   * 重复跳过
   */
  @ApiModelProperty(name = "repeatSkip", value = "重复跳过", required = true)
  @Column(name = "repeat_skip", nullable = false , columnDefinition = "bit(1) COMMENT '重复跳过'")
  @SaturnColumn(description = "重复跳过")
  private Boolean repeatSkip;
  /**
   * 为空跳过
   */
  @ApiModelProperty(name = "nullSkip", value = "为空跳过", required = true)
  @Column(name = "null_skip", length = 1, nullable = false, columnDefinition = "bit(1) COMMENT '为空跳过'")
  @SaturnColumn(description = "为空跳过")
  private Boolean nullSkip;
  /**
   * 是否可回退
   */
  @ApiModelProperty(name = "canBack", value = "是否可回退", required = true)
  @Column(name = "can_back", length = 1, nullable = false, columnDefinition = "bit(1) COMMENT '是否可回退'")
  @SaturnColumn(description = "是否可回退")
  private Boolean canBack;
  /**
   * 手动指向下一个
   */
  @ApiModelProperty(name = "manualNext", value = "手动指向下一个", required = true)
  @Column(name = "manual_next", nullable = false, columnDefinition = "bit(1) COMMENT '手动指向下一个'")
  @SaturnColumn(description = "手动指向下一个")
  private Boolean manualNext;
  /**
   * 撤销标识
   */
  @ApiModelProperty(name = "cancelFlag", value = "撤销标识", required = true)
  @Column(name = "cancel_flag", nullable = false, columnDefinition = "bit(1) COMMENT '撤销标识'")
  @SaturnColumn(description = "撤销标识")
  private Boolean cancelFlag;
  /**
   * 审批人
   */
  @ApiModelProperty(name = "assignment", value = "审批人")
  @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "processTemplateNode")
  @SaturnColumn(description = "审批人")
  private ProcessTemplateNodeAssignmentEntity assignment;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   * 会签属性
   */
  @ApiModelProperty(name = "processTemplateNodeMulti", value = "会签属性")
  @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "processTemplateNode")
  @SaturnColumn(description = "会签属性")
  private ProcessTemplateNodeMultiEntity processTemplateNodeMulti;
  /**
   * 流程节点权限
   */
  @ApiModelProperty(name = "processTemplateNodePermission", value = "流程节点权限")
  @SaturnColumn(description = "流程节点权限")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template_node_permission", columnDefinition = "varchar(255) COMMENT '流程节点权限'")
  private ProcessTemplateNodePermissionEntity processTemplateNodePermission;

  public String getProcessNodeId() {
    return processNodeId;
  }

  public void setProcessNodeId(String processNodeId) {
    this.processNodeId = processNodeId;
  }

  public String getProcessNodeName() {
    return processNodeName;
  }

  public void setProcessNodeName(String processNodeName) {
    this.processNodeName = processNodeName;
  }

  public String getProcessNodeDoc() {
    return processNodeDoc;
  }

  public void setProcessNodeDoc(String processNodeDoc) {
    this.processNodeDoc = processNodeDoc;
  }

  public ProcessTemplateEntity getProcessTemplate() {
    return processTemplate;
  }

  public void setProcessTemplate(ProcessTemplateEntity processTemplate) {
    this.processTemplate = processTemplate;
  }

  public String getFormVisibilityName() {
    return formVisibilityName;
  }

  public void setFormVisibilityName(String formVisibilityName) {
    this.formVisibilityName = formVisibilityName;
  }

  public String getBtnAuth() {
    return btnAuth;
  }

  public void setBtnAuth(String btnAuth) {
    this.btnAuth = btnAuth;
  }

  public Boolean getRepeatSkip() {
    return repeatSkip;
  }

  public void setRepeatSkip(Boolean repeatSkip) {
    this.repeatSkip = repeatSkip;
  }

  public Boolean getNullSkip() {
    return nullSkip;
  }

  public void setNullSkip(Boolean nullSkip) {
    this.nullSkip = nullSkip;
  }

  public Boolean getCanBack() {
    return canBack;
  }

  public void setCanBack(Boolean canBack) {
    this.canBack = canBack;
  }

  public Boolean getManualNext() {
    return manualNext;
  }

  public void setManualNext(Boolean manualNext) {
    this.manualNext = manualNext;
  }

  public Boolean getCancelFlag() {
    return cancelFlag;
  }

  public void setCancelFlag(Boolean cancelFlag) {
    this.cancelFlag = cancelFlag;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public ProcessTemplateNodeAssignmentEntity getAssignment() {
    return assignment;
  }

  public void setAssignment(ProcessTemplateNodeAssignmentEntity assignment) {
    this.assignment = assignment;
  }

  public ProcessTemplateNodePermissionEntity getProcessTemplateNodePermission() {
    return processTemplateNodePermission;
  }

  public void setProcessTemplateNodePermission(ProcessTemplateNodePermissionEntity processTemplateNodePermission) {
    this.processTemplateNodePermission = processTemplateNodePermission;
  }

  public ProcessTemplateNodeMultiEntity getProcessTemplateNodeMulti() {
    return processTemplateNodeMulti;
  }

  public void setProcessTemplateNodeMulti(ProcessTemplateNodeMultiEntity processTemplateNodeMulti) {
    this.processTemplateNodeMulti = processTemplateNodeMulti;
  }
}
