package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 17:22
 * @Description: 流程模版节点的操作权限
 */
@Entity
@ApiModel(value = "ProcessTemplateNodePermissionEntity", description = "流程模版节点的操作权限")
@Table(name = "engine_process_template_node_permission")
@org.hibernate.annotations.Table(appliesTo = "engine_process_template_node_permission" , comment = "流程模版节点的操作权限")
public class ProcessTemplateNodePermissionEntity extends UuidEntity {
  private static final long serialVersionUID = 3643519922188062978L;
  /**
   * 操作编码
   */
  @ApiModelProperty(name = "operateCode", value = "操作编码", required = true)
  @SaturnColumn(description = "操作编码")
  @Column(name="operate_code", nullable=false, unique = true, columnDefinition = "varchar(255) COMMENT '操作编码'")
  private String operateCode;
  /**
   * 操作名称
   */
  @ApiModelProperty(name = "operateName", value = "操作名称", required = true)
  @SaturnColumn(description = "操作名称")
  @Column(name="operate_name", nullable=false, columnDefinition = "varchar(255) COMMENT '操作名称'")
  private String operateName;
  /**
   * 操作按钮，个个按钮用英文逗号(,)分割
   */
  @ApiModelProperty(name = "operations", value = "操作按钮", required = true)
  @SaturnColumn(description = "操作按钮")
  @Column(name="operations", nullable=false, columnDefinition = "varchar(255) COMMENT '操作按钮'")
  private String operations;
  /**
   * 创建人
   */
  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @SaturnColumn(description = "创建人")
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="create_user" , nullable=false, columnDefinition = "varchar(255) COMMENT '创建人'")
  private UserEntity createUser;
  /**
   * 最后修改人
   */
  @ApiModelProperty(name = "modifyUser", value = "最后修改人", required = true)
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="modify_user", nullable = false, columnDefinition = "varchar(255) COMMENT '最后更新人'")
  @SaturnColumn(description = "最后更新人")
  private UserEntity modifyUser;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;

  public String getOperateCode() {
    return operateCode;
  }

  public void setOperateCode(String operateCode) {
    this.operateCode = operateCode;
  }

  public String getOperateName() {
    return operateName;
  }

  public void setOperateName(String operateName) {
    this.operateName = operateName;
  }

  public String getOperations() {
    return operations;
  }

  public void setOperations(String operations) {
    this.operations = operations;
  }

  public UserEntity getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserEntity createUser) {
    this.createUser = createUser;
  }

  public UserEntity getModifyUser() {
    return modifyUser;
  }

  public void setModifyUser(UserEntity modifyUser) {
    this.modifyUser = modifyUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
