package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 09:31
 * @Description: 流程变量
 */
@Entity
@Table(name = "engine_process_variable", uniqueConstraints = {@UniqueConstraint(columnNames = {"source_id", "name"})})
@ApiModel(value = "ProcessVariableEntity", description = "流程变量")
@org.hibernate.annotations.Table(appliesTo = "engine_process_variable" , comment = "流程变量")
public class ProcessVariableEntity extends UuidEntity {
  private static final long serialVersionUID = -7497094955266321624L;
  /**
   * 资源ID
   */
  @ApiModelProperty(name = "sourceId", value = "资源ID", required = true)
  @Column(name = "source_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '资源ID'")
  @SaturnColumn(description = "资源ID")
  private String sourceId;
  /**
   * 变量名
   */
  @ApiModelProperty(name = "name", value = "变量名", required = true)
  @Column(name = "name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '变量名'")
  @SaturnColumn(description = "变量名")
  private String name;
  /**
   * 变量值
   */
  @ApiModelProperty(name = "value", value = "变量值", required = true)
  @Column(name = "value", nullable = false, columnDefinition = "varchar(255) COMMENT '变量值'")
  @SaturnColumn(description = "变量值")
  private String value;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;

  public String getSourceId() {
    return sourceId;
  }

  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
