package com.bizunited.platform.titan.vo;

import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 任务VO
 * @Author: Paul Chan
 * @Date: 2019-05-25 18:23
 */
@ApiModel(value = "TaskVo", description = "流程任务")
public class TaskVo {

  @ApiModelProperty(value = "任务ID")
  private String taskId;

  @ApiModelProperty(value = "任务节点定义key")
  private String taskDefinitionKey;

  @ApiModelProperty(value = "任务名称")
  private String taskName;

  @ApiModelProperty(value = "流程名称")
  private String processName;

  @ApiModelProperty(value = "表单编号")
  private String formNo;

  @ApiModelProperty(value = "流程实例ID")
  private String processInstanceId;

  @ApiModelProperty(value = "流程状态:0=草稿1=审批中2=已完成3=驳回4=终止5=撤销")
  private Integer processState;

  @ApiModelProperty(value = "发起人姓名")
  private String applicantUserName;

  @ApiModelProperty(value = "发起时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date createTime;

  @ApiModelProperty(value = "流程key")
  private String processKey;

  /**
   * 节点信息
   */
  @ApiModelProperty(value = "节点信息")
  private ProcessTemplateNodeEntity node;

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public String getTaskDefinitionKey() {
    return taskDefinitionKey;
  }

  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }

  public String getTaskName() {
    return taskName;
  }

  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }

  public String getProcessKey() {
    return processKey;
  }

  public void setProcessKey(String processKey) {
    this.processKey = processKey;
  }

  public String getFormNo() {
    return formNo;
  }

  public void setFormNo(String formNo) {
    this.formNo = formNo;
  }

  public String getProcessInstanceId() {
    return processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public Integer getProcessState() {
    return processState;
  }

  public void setProcessState(Integer processState) {
    this.processState = processState;
  }

  public String getApplicantUserName() {
    return applicantUserName;
  }

  public void setApplicantUserName(String applicantUserName) {
    this.applicantUserName = applicantUserName;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getProcessName() {
    return processName;
  }

  public void setProcessName(String processName) {
    this.processName = processName;
  }

  public ProcessTemplateNodeEntity getNode() {
    return node;
  }

  public void setNode(ProcessTemplateNodeEntity node) {
    this.node = node;
  }

  @Override
  public String toString() {
    return "TaskVo{" +
        "taskId='" + taskId + '\'' +
        ", taskDefinitionKey='" + taskDefinitionKey + '\'' +
        ", taskName='" + taskName + '\'' +
        ", processName='" + processName + '\'' +
        ", formNo='" + formNo + '\'' +
        ", processInstanceId='" + processInstanceId + '\'' +
        ", processState=" + processState +
        ", applicantUserName='" + applicantUserName + '\'' +
        ", createTime=" + createTime +
        ", processKey='" + processKey + '\'' +
        '}';
  }
}
