package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * 流程模版节点会签人员，以代理的方式设置审批人，代理的可以是用户名，也可以是用户职位
 * @Author: Paul Chan
 * @Date: 2019-05-31 10:13
 */
@Entity
@Table(name = "engine_process_assignment")
@ApiModel(value = "ProcessAssignmentEntity", description = "流程模版节点会签人员")
@org.hibernate.annotations.Table(appliesTo = "engine_process_assignment" , comment = "流程模版节点会签人员")
public class ProcessAssignmentEntity extends UuidEntity {

  private static final long serialVersionUID = 7521439276957013759L;
  /**
   * 资源ID
   */
  @ApiModelProperty(name = "resourceId", value = "资源ID", required = true)
  @Column(name = "resource_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '资源ID'")
  @SaturnColumn(description = "资源ID")
  private String resourceId;
  /**
   * 代理人，如果是用户名，则在用户名前加前缀"username:"
   * 如果是职位，则在职位编码前增加前缀"position:"
   */
  @ApiModelProperty(name = "assignment", value = "代理人", required = true)
  @Column(name = "assignment", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '代理人'")
  @SaturnColumn(description = "代理人")
  private String assignment;
  /**
   * 代理人名称
   */
  @ApiModelProperty(name = "assignmentName", value = "代理人名称", required = true)
  @Column(name = "assignment_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '代理人名称'")
  @SaturnColumn(description = "代理人名称")
  private String assignmentName;
  /**
   * 排序，顺序排序,默认为1
   */
  @ApiModelProperty(name = "sort", value = "排序，顺序排序", required = true)
  @Column(name = "sort", nullable = false, columnDefinition = "int(11) COMMENT '排序，顺序排序'")
  @SaturnColumn(description = "排序，顺序排序")
  private Integer sort;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;

  public String getResourceId() {
    return resourceId;
  }

  public void setResourceId(String resourceId) {
    this.resourceId = resourceId;
  }

  public String getAssignment() {
    return assignment;
  }

  public void setAssignment(String assignment) {
    this.assignment = assignment;
  }

  public String getAssignmentName() {
    return assignmentName;
  }

  public void setAssignmentName(String assignmentName) {
    this.assignmentName = assignmentName;
  }

  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  @Override
  public String toString() {
    return "ProcessAssignmentEntity{" +
        "resourceId='" + resourceId + '\'' +
        ", assignment='" + assignment + '\'' +
        ", assignmentName='" + assignmentName + '\'' +
        ", sort=" + sort +
        ", createTime=" + createTime +
        ", modifyTime=" + modifyTime +
        '}';
  }
}
