package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 15:13
 * @Description: 流程检测记录
 */
@ApiModel(value = "ProcessCheckRecordEntity", description = "流程检测记录")
@Entity
@Table(name = "engine_process_check_record")
@org.hibernate.annotations.Table(appliesTo = "engine_process_check_record" , comment = "流程检测记录")
public class ProcessCheckRecordEntity extends UuidEntity {
  private static final long serialVersionUID = -8147148629089576523L;
  /**
   * 标题
   */
  @ApiModelProperty(name = "title", value = "标题", required = true)
  @Column(name = "title", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '标题'")
  @SaturnColumn(description = "标题")
  private String title;
  /**
   * 状态（0未完成，1成功，2失败）
   */
  @ApiModelProperty(name = "state", value = "状态（0未完成，1成功，2失败）", required = true)
  @Column(name = "state", nullable = false, columnDefinition = "int(11) COMMENT '状态（0未完成，1成功，2失败）'")
  @SaturnColumn(description = "状态（0未完成，1成功，2失败）")
  private Integer state;
  /**
   * 运行参数
   */
  @ApiModelProperty(name = "params", value = "运行参数", required = true)
  @Column(name = "params", length = 1024, nullable = false, columnDefinition = "varchar(1024) COMMENT '运行参数'")
  @SaturnColumn(description = "运行参数")
  private String params;
  /**
   * 运行结果
   */
  @ApiModelProperty(name = "result", value = "运行结果", required = true)
  @Column(name = "result", length = 1024, nullable = false, columnDefinition = "varchar(1024) COMMENT '运行结果'")
  @SaturnColumn(description = "运行结果")
  private String result;
  /**
   * 流程模版
   */
  @ApiModelProperty(name = "processTemplate", value = "流程模版", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template", nullable = false, columnDefinition = "varchar(255) COMMENT '流程模版'")
  @SaturnColumn(description = "流程模版")
  private ProcessTemplateEntity processTemplate;
  /**
   * 流程实例ID
   */
  @ApiModelProperty(name = "processInstanceId", value = "流程实例ID")
  @Column(name = "process_instance_id", length = 128, columnDefinition = "varchar(128) COMMENT '流程实例ID'")
  @SaturnColumn(description = "流程实例ID")
  private String processInstanceId;
  /**
   * 流程定义ID
   */
  @ApiModelProperty(name = "processDefId", value = "流程定义ID", required = true)
  @Column(name = "process_def_id", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '流程定义ID'")
  @SaturnColumn(description = "流程定义ID")
  private String processDefId;
  /**
   * 流程定义ID
   */
  @ApiModelProperty(name = "testProcessDefId", value = "流程定义ID", required = true)
  @Column(name = "test_process_def_id", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '测试的流程定义ID'")
  @SaturnColumn(description = "测试的流程定义ID")
  private String testProcessDefId;
  /**
   * 明细
   */
  @ApiModelProperty(name = "processCheckRecordItems", value = "明细")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "processCheckRecord")
  @SaturnColumn(description = "明细")
  private Set<ProcessCheckRecordItemEntity> processCheckRecordItems;
  /**
   * 创建人
   */
  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "create_user", nullable = false, columnDefinition = "varchar(255) COMMENT '创建人'")
  @SaturnColumn(description = "创建人")
  private UserEntity createUser;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getParams() {
    return params;
  }

  public void setParams(String params) {
    this.params = params;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public ProcessTemplateEntity getProcessTemplate() {
    return processTemplate;
  }

  public void setProcessTemplate(ProcessTemplateEntity processTemplate) {
    this.processTemplate = processTemplate;
  }

  public String getProcessInstanceId() {
    return processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public String getProcessDefId() {
    return processDefId;
  }

  public void setProcessDefId(String processDefId) {
    this.processDefId = processDefId;
  }

  public String getTestProcessDefId() {
    return testProcessDefId;
  }

  public void setTestProcessDefId(String testProcessDefId) {
    this.testProcessDefId = testProcessDefId;
  }

  public Set<ProcessCheckRecordItemEntity> getProcessCheckRecordItems() {
    return processCheckRecordItems;
  }

  public void setProcessCheckRecordItems(Set<ProcessCheckRecordItemEntity> processCheckRecordItems) {
    this.processCheckRecordItems = processCheckRecordItems;
  }

  public UserEntity getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserEntity createUser) {
    this.createUser = createUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
