package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 10:19
 * @Description: 流程模版的定义的编辑器草稿和流程的基础配置
 */
@ApiModel(value = "ProcessTemplateEntity", description = "流程模版的定义的编辑器草稿和流程的基础配置")
@Entity
@Table(name = "engine_process_template", uniqueConstraints = {@UniqueConstraint(columnNames = {"file_path", "file_name"}),
                                                              @UniqueConstraint(columnNames = {"process_key", "cversion"})})
@org.hibernate.annotations.Table(appliesTo = "engine_process_template" , comment = "流程模版的定义的编辑器草稿和流程的基础配置")
public class ProcessTemplateEntity extends UuidEntity {
  private static final long serialVersionUID = 3232221240973625289L;
  /**
   * 流程key
   */
  @ApiModelProperty(name = "processKey", value = "流程key", required = true)
  @Column(name = "process_key", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '流程key'")
  @SaturnColumn(description = "流程key")
  private String processKey;
  /**
   * 流程名称
   */
  @ApiModelProperty(name = "processName", value = "流程名称", required = true)
  @Column(name = "process_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '流程名称'")
  @SaturnColumn(description = "流程名称")
  private String processName;
  /**
   * 流程说明
   */
  @ApiModelProperty(name = "processDoc", value = "流程说明")
  @Column(name = "process_doc", length = 128, columnDefinition = "varchar(128) COMMENT '流程说明'")
  @SaturnColumn(description = "流程说明")
  private String processDoc;
  /**
   * 流程状态0:编辑，1:已发布
   */
  @ApiModelProperty(name = "processState", value = "流程状态0:编辑，1:已发布", required = true)
  @Column(name = "process_state", nullable = false, columnDefinition = "int(11) COMMENT '流程状态0:编辑，1:已发布'")
  @SaturnColumn(description = "流程状态0:编辑，1:已发布")
  private Integer processState;
  /**
   * 流程文件路径
   */
  @ApiModelProperty(name = "filePath", value = "流程文件路径", required = true)
  @Column(name = "file_path", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '流程文件路径'")
  @SaturnColumn(description = "流程文件路径")
  private String filePath;
  /**
   * 流程文件名
   */
  @ApiModelProperty(name = "fileName", value = "流程文件名", required = true)
  @Column(name = "file_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '流程文件名'")
  @SaturnColumn(description = "流程文件名")
  private String fileName;
  /**
   * 版本号
   */
  @ApiModelProperty(name = "cversion", value = "版本号", required = true)
  @Column(name = "cversion", nullable = false, columnDefinition = "int(11) COMMENT '版本号'")
  @SaturnColumn(description = "版本号")
  private Integer cversion;
  /**
   * 流程定义ID
   */
  @ApiModelProperty(name = "processDefinitionId", value = "流程定义ID")
  @Column(name = "process_definition_id", length = 64, columnDefinition = "varchar(64) COMMENT '流程定义ID'")
  @SaturnColumn(description = "流程定义ID")
  private String processDefinitionId;
  /**
   * 表单类型：0=无表单1=表单实例=表单地址
   */
  @ApiModelProperty(name = "formType", value = "表单类型：0=无表单1=表单实例2=表单地址", required = true)
  @Column(name = "form_type", nullable = false, columnDefinition = "int(11) COMMENT '表单类型：0=无表单1=表单实例2=表单地址'")
  @SaturnColumn(description = "表单类型：0=无表单1=表单实例2=表单地址")
  private Integer formType;
  /**
   * 表单模版ID
   */
  @ApiModelProperty(name = "formTemplateId", value = "表单模版ID")
  @SaturnColumn(description = "表单模版ID")
  @Column(name="form_template_id", length=64, columnDefinition = "varchar(64) COMMENT '表单类型：0=无表单1=表单实例2=表单地址'")
  private String formTemplateId;
  /**
   * 表单名称
   */
  @ApiModelProperty(name = "formName", value = "表单名称")
  @SaturnColumn(description = "表单名称")
  @Column(name="form_name", length = 32, columnDefinition = "varchar(32) COMMENT '表单名称'")
  private String formName;
  /**
   * 表单版本
   */
  @ApiModelProperty(name = "formVersion", value = "表单版本")
  @SaturnColumn(description = "表单版本")
  @Column(name="form_version", length = 32, columnDefinition = "varchar(32) COMMENT '表单版本'")
  private String formVersion;
  /**
   * 表单地址
   */
  @ApiModelProperty(name = "formUrl", value = "表单地址")
  @Column(name = "form_url", columnDefinition = "varchar(255) COMMENT '表单地址'")
  @SaturnColumn(description = "表单地址")
  private String formUrl;
  /**
   * 表单回调地址
   */
  @ApiModelProperty(name = "formCallBackUrl", value = "表单回调地址")
  @Column(name = "form_call_back_url", columnDefinition = "varchar(255) COMMENT '表单回调地址'")
  @SaturnColumn(description = "表单回调地址")
  private String formCallBackUrl;
  /**
   * 创建人
   */
  @ApiModelProperty(name = "createUser", value = "创建人", required = true)
  @SaturnColumn(description = "创建人")
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="create_user" , nullable=false, columnDefinition = "varchar(255) COMMENT '创建人'")
  private UserEntity createUser;
  /**
   * 最后修改人
   */
  @ApiModelProperty(name = "modifyUser", value = "最后修改人", required = true)
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="modify_user", nullable = false, columnDefinition = "varchar(255) COMMENT '最后修改人'")
  @SaturnColumn(description = "最后更新人")
  private UserEntity modifyUser;
  /**
   * 部署时间
   */
  @ApiModelProperty(name = "deployTime", value = "部署时间")
  @Column(name = "deploy_time", columnDefinition = "datetime(3) COMMENT '部署时间'")
  @SaturnColumn(description = "部署时间")
  private Date deployTime;
  /**
   * 是否是最新版本
   */
  @ApiModelProperty(name = "isLastVersion", value = "是否是最新版本")
  @Column(name = "is_last_version", columnDefinition = "bit(1) COMMENT '是否是最新版本'")
  @SaturnColumn(description = "是否是最新版本")
  private Boolean isLastVersion;
  /**
   * 是否是最后发布的版本
   */
  @ApiModelProperty(name = "isLastDeployedVersion", value = "是否是最后发布的版本")
  @Column(name = "is_last_deployed_version", columnDefinition = "bit(1) COMMENT '是否是最后发布的版本'")
  @SaturnColumn(description = "是否是最后发布的版本")
  private Boolean isLastDeployedVersion;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   * 流程节点
   */
  @ApiModelProperty(name = "processTemplateNodes", value = "流程节点")
  @OneToMany(fetch=FetchType.LAZY, cascade = CascadeType.REMOVE, mappedBy="processTemplate")
  @SaturnColumn(description = "流程节点")
  private Set<ProcessTemplateNodeEntity> processTemplateNodes;
  /**
   * 模版使用权限
   */
  @ApiModelProperty(name = "permissions", value = "模版使用权限")
  @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.REMOVE, mappedBy = "processTemplate")
  @SaturnColumn(description = "模版使用权限")
  private Set<ProcessTemplatePermissionEntity> permissions;
  /**
   * 模版监听器
   */
  @ApiModelProperty(name = "processTemplateListeners", value = "模版监听器")
  @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.REMOVE, mappedBy = "processTemplate")
  @SaturnColumn(description = "模版监听器")
  private Set<ProcessTemplateListenerEntity> processTemplateListeners;
  /**
   * 提交时数据处理脚本
   */
  @ApiModelProperty(name = "onSubmitScript", value = "提交时数据处理脚本")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "on_submit_script", columnDefinition = "varchar(255) COMMENT '提交时数据处理脚本'")
  @SaturnColumn(description = "提交时数据处理脚本")
  private ScriptEntity onSubmitScript;
  /**
   * 流程模版文件内容
   */
  @Transient
  @SaturnColumn(description = "流程模版文件内容")
  @ApiModelProperty(name = "processXml", value = "流程模版文件内容")
  private String processXml;
  /**
   * 流程预置变量
   */
  @Transient
  @SaturnColumn(description = "流程预置变量")
  @ApiModelProperty(name = "variables", value = "流程预置变量")
  private Set<ProcessVariableEntity> variables;

  public String getProcessKey() {
    return processKey;
  }

  public void setProcessKey(String processKey) {
    this.processKey = processKey;
  }

  public String getProcessName() {
    return processName;
  }

  public void setProcessName(String processName) {
    this.processName = processName;
  }

  public String getProcessDoc() {
    return processDoc;
  }

  public void setProcessDoc(String processDoc) {
    this.processDoc = processDoc;
  }

  public Integer getProcessState() {
    return processState;
  }

  public void setProcessState(Integer processState) {
    this.processState = processState;
  }



  public Integer getCversion() {
    return cversion;
  }

  public void setCversion(Integer cversion) {
    this.cversion = cversion;
  }

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public Integer getFormType() {
    return formType;
  }

  public void setFormType(Integer formType) {
    this.formType = formType;
  }

  public String getFormTemplateId() {
    return formTemplateId;
  }

  public void setFormTemplateId(String formTemplateId) {
    this.formTemplateId = formTemplateId;
  }


  public String getFormUrl() {
    return formUrl;
  }

  public void setFormUrl(String formUrl) {
    this.formUrl = formUrl;
  }

  public String getFormCallBackUrl() {
    return formCallBackUrl;
  }

  public void setFormCallBackUrl(String formCallBackUrl) {
    this.formCallBackUrl = formCallBackUrl;
  }

  public UserEntity getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserEntity createUser) {
    this.createUser = createUser;
  }

  public UserEntity getModifyUser() {
    return modifyUser;
  }

  public void setModifyUser(UserEntity modifyUser) {
    this.modifyUser = modifyUser;
  }

  public Date getDeployTime() {
    return deployTime;
  }

  public void setDeployTime(Date deployTime) {
    this.deployTime = deployTime;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public Set<ProcessTemplateNodeEntity> getProcessTemplateNodes() {
    return processTemplateNodes;
  }

  public void setProcessTemplateNodes(Set<ProcessTemplateNodeEntity> processTemplateNodes) {
    this.processTemplateNodes = processTemplateNodes;
  }

  public Set<ProcessTemplatePermissionEntity> getPermissions() {
    return permissions;
  }

  public void setPermissions(Set<ProcessTemplatePermissionEntity> permissions) {
    this.permissions = permissions;
  }

  public Set<ProcessTemplateListenerEntity> getProcessTemplateListeners() {
    return processTemplateListeners;
  }

  public void setProcessTemplateListeners(Set<ProcessTemplateListenerEntity> processTemplateListeners) {
    this.processTemplateListeners = processTemplateListeners;
  }

  public String getFilePath() {
    return filePath;
  }

  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getProcessXml() {
    return processXml;
  }

  public void setProcessXml(String processXml) {
    this.processXml = processXml;
  }

  public String getFormName() {
    return formName;
  }

  public void setFormName(String formName) {
    this.formName = formName;
  }

  public Boolean getLastVersion() {
    return isLastVersion;
  }

  public void setLastVersion(Boolean lastVersion) {
    isLastVersion = lastVersion;
  }

  public Boolean getLastDeployedVersion() {
    return isLastDeployedVersion;
  }

  public void setLastDeployedVersion(Boolean lastDeployedVersion) {
    isLastDeployedVersion = lastDeployedVersion;
  }

  public String getFormVersion() {
    return formVersion;
  }

  public void setFormVersion(String formVersion) {
    this.formVersion = formVersion;
  }

  public Set<ProcessVariableEntity> getVariables() {
    return variables;
  }

  public void setVariables(Set<ProcessVariableEntity> variables) {
    this.variables = variables;
  }

  public ScriptEntity getOnSubmitScript() {
    return onSubmitScript;
  }

  public void setOnSubmitScript(ScriptEntity onSubmitScript) {
    this.onSubmitScript = onSubmitScript;
  }
}
