package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 17:09
 * @Description: 流程模版监听器配置
 */
@ApiModel(value = "ProcessTemplateListenerEntity", description = "流程模版监听器配置")
@Entity
@Table(name = "engine_process_template_listener")
@org.hibernate.annotations.Table(appliesTo = "engine_process_template_listener" , comment = "流程模版监听器配置")
public class ProcessTemplateListenerEntity extends UuidEntity {
  private static final long serialVersionUID = 6025322564870211760L;
  /**
   * 流程模版
   */
  @ApiModelProperty(name = "processTemplate", value = "流程模版", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template", nullable = false, columnDefinition = "varchar(255) COMMENT '流程模版'")
  @SaturnColumn(description = "流程模版")
  private ProcessTemplateEntity processTemplate;
  /**
   * 目标节点定义ID
   */
  @ApiModelProperty(name = "targetId", value = "目标节点定义ID", required = true)
  @Column(name = "target_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '目标节点定义ID'")
  @SaturnColumn(description = "目标节点定义ID")
  private String targetId;
  /**
   * 监听器
   */
  @ApiModelProperty(name = "processListener", value = "监听器", required = true)
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_listener", nullable = false, columnDefinition = "varchar(255) COMMENT '监听器'")
  @SaturnColumn(description = "监听器")
  private ProcessListenerEntity processListener;
  /**
   * 脚本,当监听器为脚本监听器时有
   */
  @ApiModelProperty(name = "script", value = "脚本,当监听器为脚本监听器时有")
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "script", columnDefinition = "varchar(255) COMMENT '脚本,当监听器为脚本监听器时有'")
  @SaturnColumn(description = "脚本,当监听器为脚本监听器时有")
  private ScriptEntity script;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   * 监听器变量
   */
  @Transient
  @ApiModelProperty(name = "variables", value = "监听器变量")
  private Set<ProcessVariableEntity> variables;

  public ProcessTemplateEntity getProcessTemplate() {
    return processTemplate;
  }

  public void setProcessTemplate(ProcessTemplateEntity processTemplate) {
    this.processTemplate = processTemplate;
  }

  public String getTargetId() {
    return targetId;
  }

  public void setTargetId(String targetId) {
    this.targetId = targetId;
  }

  public ProcessListenerEntity getProcessListener() {
    return processListener;
  }

  public void setProcessListener(ProcessListenerEntity processListener) {
    this.processListener = processListener;
  }

  public ScriptEntity getScript() {
    return script;
  }

  public void setScript(ScriptEntity script) {
    this.script = script;
  }

  public Set<ProcessVariableEntity> getVariables() {
    return variables;
  }

  public void setVariables(Set<ProcessVariableEntity> variables) {
    this.variables = variables;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
