package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * 流程模版节点会签属性
 * @Author: Paul Chan
 * @Date: 2019-05-31 10:04
 */
@Entity
@Table(name = "engine_process_template_node_multi")
@ApiModel(value = "ProcessTemplateNodeMultiEntity", description = "流程模版节点会签属性")
@org.hibernate.annotations.Table(appliesTo = "engine_process_template_node_multi" , comment = "流程模版节点会签属性")
public class ProcessTemplateNodeMultiEntity extends UuidEntity {

  private static final long serialVersionUID = 8282589492865238998L;
  /**
   * 模版节点
   */
  @ApiModelProperty(name = "processTemplateNode", value = "模版节点", required = true)
  @OneToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template_node", nullable = false, unique = true , columnDefinition = "varchar(255) COMMENT '模版节点'")
  @SaturnColumn(description = "模版节点")
  private ProcessTemplateNodeEntity processTemplateNode;
  /**
   * 会签类型：0=不会签1=平行会签2=串行会签
   */
  @ApiModelProperty(name = "miType", value = "会签类型：0=不会签1=平行会签2=串行会签", required = true)
  @Column(name = "mi_type",  nullable = false, columnDefinition = "int(11) COMMENT '会签类型：0=不会签1=平行会签2=串行会签'")
  @SaturnColumn(description = "会签类型：0=不会签1=平行会签2=串行会签")
  private Integer miType;
  /**
   * 是否预置会签人员
   */
  @ApiModelProperty(name = "presetMiAssignments", value = "是否预置会签人员")
  @Column(name = "is_preset_mi_Assignments", columnDefinition = "bit(1) COMMENT '是否预置会签人员'")
  @SaturnColumn(description = "是否预置会签人员")
  private Boolean presetMiAssignments;
  /**
   * 会签通过条件，EL表达式如:${nrOfCompletedInstances/nrOfInstances >= 0.6}
   * nrOfCompletedInstances:当前任务已同意的人数
   * nrOfInstances:当前会签任务的总人数
   */
  @ApiModelProperty(name = "completionCondition", value = "会签通过条件值")
  @Column(name = "completion_condition", columnDefinition = "varchar(255) COMMENT '会签通过条件值'")
  @SaturnColumn(description = "会签通过条件值")
  private String completionCondition;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;
  /**
   *  会签人员
   */
  @Transient
  @ApiModelProperty(name = "assignments", value = "会签人员")
  @SaturnColumn(description = "会签人员")
  private Set<ProcessAssignmentEntity> assignments;

  public ProcessTemplateNodeEntity getProcessTemplateNode() {
    return processTemplateNode;
  }

  public void setProcessTemplateNode(ProcessTemplateNodeEntity processTemplateNode) {
    this.processTemplateNode = processTemplateNode;
  }

  public Integer getMiType() {
    return miType;
  }

  public void setMiType(Integer miType) {
    this.miType = miType;
  }

  public Boolean getPresetMiAssignments() {
    return presetMiAssignments;
  }

  public void setPresetMiAssignments(Boolean presetMiAssignments) {
    this.presetMiAssignments = presetMiAssignments;
  }

  public String getCompletionCondition() {
    return completionCondition;
  }

  public void setCompletionCondition(String completionCondition) {
    this.completionCondition = completionCondition;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public Set<ProcessAssignmentEntity> getAssignments() {
    return assignments;
  }

  public void setAssignments(Set<ProcessAssignmentEntity> assignments) {
    this.assignments = assignments;
  }
}
