package com.bizunited.platform.titan.entity;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-11 10:33
 * @Description: 流程模版权限
 */
@ApiModel(value = "ProcessTemplatePermissionEntity", description = "流程模版权限")
@Entity
@Table(name = "engine_process_template_permission")
@org.hibernate.annotations.Table(appliesTo = "engine_process_template_permission" , comment = "流程模版权限")
public class ProcessTemplatePermissionEntity extends UuidEntity {
  private static final long serialVersionUID = 7381975686664477121L;
  /**
   * 流程模版
   */
  @ApiModelProperty(name = "processTemplate", value = "流程模版", required = true)
  @OneToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "process_template", nullable = false, columnDefinition = "varchar(255) COMMENT '流程模版'")
  @SaturnColumn(description = "流程模版")
  private ProcessTemplateEntity processTemplate;
  /**
   * 权限类型:0=所有人可用1=指定用户2=指定角色3=分组4=指定职位5=指定组织
   */
  @ApiModelProperty(name = "type", value = "权限类型:0=所有人可用1=指定用户2=指定角色3=分组4=指定职位5=指定组织", required = true)
  @Column(name = "type", nullable = false, columnDefinition = "int(11) COMMENT '权限类型:0=所有人可用1=指定用户2=指定角色3=分组4=指定职位5=指定组织'")
  @SaturnColumn(description = "权限类型:0=所有人可用1=指定用户2=指定角色3=分组4=指定职位5=指定组织")
  private Integer type;
  /**
   * 权限值
   */
  @ApiModelProperty(name = "permissionValue", value = "权限值", required = true)
  @Column(name = "permission_value", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '权限值'")
  @SaturnColumn(description = "权限值")
  private String permissionValue;
  /**
   * 权限名称
   */
  @ApiModelProperty(name = "permissionName", value = "权限名称", required = true)
  @Column(name = "permission_name", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '权限名称'")
  @SaturnColumn(description = "权限名称")
  private String permissionName;
  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 最后修改时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后修改时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date modifyTime;

  public ProcessTemplateEntity getProcessTemplate() {
    return processTemplate;
  }

  public void setProcessTemplate(ProcessTemplateEntity processTemplate) {
    this.processTemplate = processTemplate;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getPermissionValue() {
    return permissionValue;
  }

  public void setPermissionValue(String permissionValue) {
    this.permissionValue = permissionValue;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public String getPermissionName() {
    return permissionName;
  }

  public void setPermissionName(String permissionName) {
    this.permissionName = permissionName;
  }
}
