package com.bizunited.platform.titan.vo;

import com.bizunited.platform.titan.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;

/**
 * 流程图节点信息
 * @Author: Paul Chan
 * @Date: 2019-05-28 14:24
 */
@ApiModel(description = "流程图节点信息")
public class ProcessImageNodeVo {

  /**
   * X坐标
   */
  @ApiModelProperty(value = "X坐标")
  private Double x;

  /**
   * Y坐标
   */
  @ApiModelProperty(value = "Y坐标")
  private Double y;

  /**
   * 宽
   */
  @ApiModelProperty(value = "宽")
  private Double width;

  /**
   * 高
   */
  @ApiModelProperty(value = "高")
  private Double height;

  /**
   * 审批状态
   */
  @ApiModelProperty(value = "审批状态")
  private Integer state;

  /**
   * 审批人
   */
  @ApiModelProperty(value = "审批人")
  private String assignments;

  /**
   * 审批人姓名
   */
  @ApiModelProperty(value = "审批人姓名")
  private String assignmentNames;

  /**
   * 开始时间
   */
  @ApiModelProperty(value = "开始时间")
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty(value = "结束时间")
  private Date endTime;

  /**
   * 节点操作记录
   */
  @ApiModelProperty(value = "节点操作记录")
  private Set<ProcessInstanceOperateRecordEntity> records;

  /**
   * 节点信息
   */
  @ApiModelProperty(value = "节点信息")
  private ProcessTemplateNodeEntity node;

  public Double getX() {
    return x;
  }

  public void setX(Double x) {
    this.x = x;
  }

  public Double getY() {
    return y;
  }

  public void setY(Double y) {
    this.y = y;
  }

  public Double getWidth() {
    return width;
  }

  public void setWidth(Double width) {
    this.width = width;
  }

  public Double getHeight() {
    return height;
  }

  public void setHeight(Double height) {
    this.height = height;
  }

  public Set<ProcessInstanceOperateRecordEntity> getRecords() {
    return records;
  }

  public void setRecords(Set<ProcessInstanceOperateRecordEntity> records) {
    this.records = records;
  }

  public ProcessTemplateNodeEntity getNode() {
    return node;
  }

  public void setNode(ProcessTemplateNodeEntity node) {
    this.node = node;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getAssignments() {
    return assignments;
  }

  public void setAssignments(String assignments) {
    this.assignments = assignments;
  }

  public String getAssignmentNames() {
    return assignmentNames;
  }

  public void setAssignmentNames(String assignmentNames) {
    this.assignmentNames = assignmentNames;
  }

  public Date getStartTime() {
    return startTime;
  }

  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }

  public Date getEndTime() {
    return endTime;
  }

  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }

  @Override
  public String toString() {
    return "ProcessImageNodeVo{" +
        "x=" + x +
        ", y=" + y +
        ", width=" + width +
        ", height=" + height +
        ", state=" + state +
        ", assignments=" + assignments +
        ", assignmentNames=" + assignmentNames +
        ", startTime=" + startTime +
        ", endTime=" + endTime +
        ", records=" + records +
        ", node=" + node +
        '}';
  }
}
