package com.bizunited.platform.titan.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * 流程图信息
 * @Author: Paul Chan
 * @Date: 2019-05-28 14:21
 */
@ApiModel(value = "processImageVO", description = "流程图信息")
public class ProcessImageVo {

  /**
   * 图片（base64编码）
   */
  @ApiModelProperty(value = "图片（base64编码）")
  private String image;

  /**
   * 流程设计文件
   */
  @ApiModelProperty(value = "流程设计文件")
  private String processXml;

  /**
   * 最小X坐标
   */
  @ApiModelProperty(value = "最小X坐标")
  private Integer minX;

  /**
   * 最小Y坐标
   */
  @ApiModelProperty(value = "最小Y坐标")
  private Integer minY;

  /**
   * 图片宽
   */
  @ApiModelProperty(value = "图片宽")
  private Integer width;

  /**
   * 图片宽
   */
  @ApiModelProperty(value = "图片高")
  private Integer height;

  /**
   * 节点信息
   */
  @ApiModelProperty(value = "节点信息")
  private Set<ProcessImageNodeVo> imageNodes;

  /**
   * 高亮的节点，当前待办任务，以逗号(,)分割
   */
  @ApiModelProperty(value = "高亮的节点，当前待办任务，以逗号(,)分割")
  private String highLightedActivities;

  /**
   * 高亮的线，以逗号(,)分割
   */
  @ApiModelProperty(value = "高亮的线，以逗号(,)分割")
  private String highLightedFlows;

  /**
   * 高亮的节点，历史任务，以逗号(,)分割
   */
  @ApiModelProperty(value = "高亮的节点，历史任务，以逗号(,)分割")
  private String highLightedHisActivities;

  public String getImage() {
    return image;
  }

  public void setImage(String image) {
    this.image = image;
  }

  public Set<ProcessImageNodeVo> getImageNodes() {
    return imageNodes;
  }

  public void setImageNodes(Set<ProcessImageNodeVo> imageNodes) {
    this.imageNodes = imageNodes;
  }

  public Integer getMinX() {
    return minX;
  }

  public void setMinX(Integer minX) {
    this.minX = minX;
  }

  public Integer getMinY() {
    return minY;
  }

  public void setMinY(Integer minY) {
    this.minY = minY;
  }

  public Integer getWidth() {
    return width;
  }

  public void setWidth(Integer width) {
    this.width = width;
  }

  public Integer getHeight() {
    return height;
  }

  public void setHeight(Integer height) {
    this.height = height;
  }

  public String getProcessXml() {
    return processXml;
  }

  public void setProcessXml(String processXml) {
    this.processXml = processXml;
  }

  public String getHighLightedActivities() {
    return highLightedActivities;
  }

  public void setHighLightedActivities(String highLightedActivities) {
    this.highLightedActivities = highLightedActivities;
  }

  public String getHighLightedFlows() {
    return highLightedFlows;
  }

  public void setHighLightedFlows(String highLightedFlows) {
    this.highLightedFlows = highLightedFlows;
  }

  public String getHighLightedHisActivities() {
    return highLightedHisActivities;
  }

  public void setHighLightedHisActivities(String highLightedHisActivities) {
    this.highLightedHisActivities = highLightedHisActivities;
  }

  @Override
  public String toString() {
    return "ProcessImageVo{" +
        "image='" + image + '\'' +
        ", processXml='" + processXml + '\'' +
        ", minX=" + minX +
        ", minY=" + minY +
        ", width=" + width +
        ", height=" + height +
        ", imageNodes=" + imageNodes +
        ", highLightedActivities=" + highLightedActivities +
        ", highLightedFlows=" + highLightedFlows +
        ", highLightedHisActivities=" + highLightedHisActivities +
        '}';
  }
}
