package com.bizunited.platform.titan.starter.command;

import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Execution;
import org.flowable.task.api.Task;

import java.util.Map;

import static com.bizunited.platform.titan.starter.common.Constants.*;

/**
 * 在驳回之前做预言，预言这次驳回后，后面的所有审批是否还能继续，不能继续则直接驳回
 * 如果为false，则会签结束，如果为true，则会签继续
 * @Author: Paul Chan
 * @Date: 2019-06-03 11:28
 */
public class ProphesyMultiCompletionBeforeRejectCommand implements Command<Boolean> {

  private Task task;
  /**
   * 当前一次性驳回的人数
   */
  private int rejectCount;
  private UserTask userTask;
  private RuntimeService runtimeService;

  public ProphesyMultiCompletionBeforeRejectCommand(RuntimeService runtimeService, Task task, UserTask userTask, int rejectCount){
    this.task = task;
    this.userTask = userTask;
    this.rejectCount = rejectCount;
    this.runtimeService = runtimeService;
  }

  @Override
  public Boolean execute(CommandContext commandContext) {
    MultiInstanceLoopCharacteristics loopCharacteristics = userTask.getLoopCharacteristics();
    Validate.notNull(loopCharacteristics, "未找到用户任务节点的会签配置信息");
    String completionCondition = loopCharacteristics.getCompletionCondition();
    // 获取EL表达式执行器
    ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
    Expression expression = expressionManager.createExpression(completionCondition);
    // 创建一个空的执行实例
    ExecutionEntityImpl executionEntity = ExecutionEntityImpl.createWithEmptyRelationshipCollections();
    // 获取当前任务的变量并倾倒如执行实例里
    Map<String, Object> variables = runtimeService.getVariables(task.getExecutionId());
    executionEntity.setVariables(variables);
    // 计算当前任务驳回后剩余可通过数的总量
    Integer nrOfInstances = (Integer) executionEntity.getVariable(NR_OF_INSTANCES);
    Execution execution = runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
    Integer nrOfRejectedInstances = (Integer) runtimeService.getVariableLocal(execution.getParentId(), NR_OF_REJECTED_INSTANCES);
    nrOfRejectedInstances = nrOfRejectedInstances == null? 0 : nrOfRejectedInstances;
    // 预言当前任务已经驳回，驳回数加一
    nrOfRejectedInstances += rejectCount;
    Integer nrOfCompletedInstances = nrOfInstances - nrOfRejectedInstances;
    // 将预言的总通过数放到EL执行器变量中执行
    executionEntity.setVariable(NR_OF_COMPLETED_INSTANCES, nrOfCompletedInstances);
    Boolean value = (Boolean) expression.getValue(executionEntity);
    // 执行完后删除临时的执行变量，防止起持久化到数据库中
    executionEntity.removeVariables();
    return value;
  }

}
