package com.bizunited.platform.titan.starter.common;

import com.bizunited.platform.titan.starter.common.enums.TaskOperateBtn;

import java.util.HashMap;
import java.util.Map;

/**
 * 静态变量
 * @Author: Paul Chan
 * @Date: 2019-05-23 10:46
 */
public class Constants {

  /**
   * 流程第一个节点固定的ID
   */
  public final static String NODE_ID_DEFAULT_START = "DEFAULT_START";

  /**
   * 发起审批节点的审批人配置
   */
  public final static String TASK_DEFAULT_START_ASSIGNMENT = "${applicantUser}";

  /**
   * 发起审批节点的审批人配置的name
   */
  public final static String TASK_DEFAULT_START_ASSIGNMENT_NAME = "applicantUser";

  /**
   * 预置会签人员列表名的后缀
   */
  public final static String TASK_MULTI_COLLECTION_SUFFIX = "_mi_assignments";

  /**
   * 已处理的会签人的列表名后缀
   */
  public final static String TASK_MULTI_COMPLETED_ASSIGNMENTS_SUFFIX = "_mi_completed_assignments";

  /**
   * 预置会签节点任务人的变量名后缀
   */
  public final static String TASK_MULTI_ELEMENT_VARIABLE = "_mi_assignment";

  /**
   * 多实例的总数
   */
  public final static String NR_OF_INSTANCES = "nrOfInstances";

  /**
   * 多实例已驳回的数量
   */
  public final static String NR_OF_REJECTED_INSTANCES = "nrOfRejectedInstances";

  /**
   * 多实例已通过的数量
   */
  public final static String NR_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";

  /**
   * 遍历的计数器
   */
  public final static String LOOP_COUNTER = "loopCounter";

  /**
   * 默认查询站位编码
   */
  public final static String DEFAULT_QUERY_COVER_CODE = "-0001";

  /**
   * 用户前缀
   */
  public final static String USERNAME_PREFIX = "username:";

  /**
   * 职位前缀
   */
  public final static String POSITION_PREFIX = "position:";

  /**
   * 节点任务的按钮缓存
   */
  public final static Map<String, TaskOperateBtn> TASK_OPERATION_BTN_MAP = new HashMap<>(16);

  static {
    TaskOperateBtn[] btns = TaskOperateBtn.values();
    for (TaskOperateBtn btn : btns) {
      TASK_OPERATION_BTN_MAP.put(btn.getBtn(), btn);
    }
  }

}
