package com.bizunited.platform.titan.starter.common.enums;

/**
 * 流程状态
 * @Author: Paul Chan
 * @Date: 2019-05-23 09:04
 */
public enum ProcessInstanceState {
  DRAFT(0, "草稿"),
  APPROVING(1, "审批中"),
  COMPLETED(2, "已完成"),
  REJECTED(3, "已驳回"),
  STOPPED(4, "已终止"),
  CANCELED(5, "已撤回");

  private Integer state;
  private String desc;

  ProcessInstanceState(Integer state, String desc){
    this.state = state;
    this.desc = desc;
  }

  public Integer getState() {
    return state;
  }

  public String getDesc() {
    return desc;
  }
}
