package com.bizunited.platform.titan.starter.configuration;

import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.core.service.serviceable.handle.ServicableInvokeHandle;
import com.bizunited.platform.core.service.serviceable.handle.SpringMVCResponseHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.*;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.ProcessInstanceHandle;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

/**
 * 该配置信息，是对流程引擎中使用的服务源链式代理调用进行的必要配置描述
 * @Author: Paul Chan
 * @Date: 2019-06-05 13:59
 */
@Configuration("TitanProxyInvokeConfig")
public class ProxyInvokeConfig {

  /**
   * 获取一个操作流程任务和“写”表单性质的服务源执行代理器，注意，这个Bean限制了生命周期，那么每一个取得都将是一个新的执行代理器
   * @param applicationContext 上下文
   * @param principalHandle 登录认证handle
   * @param transactionalHandle 事务开启handle
   * @param processInstanceHandle 流程任务处理handle
   * @param servicableInvokeHandle 服务源调用handle
   * @param staticInstanceActivityUpdateHandle 静态表单实例活动更新handle
   * @param staticInstanceDetailsLogUpdateHandle 静态表单实例详情日志更新handle
   * @param springMVCResponseHandle 返回处理handle
   * @param beforeFormDetailsRecordHandle 表单明细记录前处理handle
   * @param afterFormDetailsRecordHandle 表单明细记录后处理handle
   * @return
   */
  @Scope("prototype")
  @Bean("ProcessOperateAndWriteFormServicableProxy")
  public InvokeProxy getProcessOperateAndWriteFormServicableProxy(ApplicationContext applicationContext,
                                                                  PrincipalHandle principalHandle,
                                                                  TransactionalHandle transactionalHandle,
                                                                  ProcessInstanceHandle processInstanceHandle,
                                                                  ServicableInvokeHandle servicableInvokeHandle,
                                                                  StaticInstanceActivityUpdateHandle staticInstanceActivityUpdateHandle,
                                                                  StaticInstanceDetailsLogUpdateHandle staticInstanceDetailsLogUpdateHandle,
                                                                  SpringMVCResponseHandle springMVCResponseHandle,
                                                                  @Qualifier("BeforeStaticFormDetailsRecordHandle") StaticFormDetailsRecordHandle beforeFormDetailsRecordHandle,
                                                                  @Qualifier("AfterStaticFormDetailsRecordHandle") StaticFormDetailsRecordHandle afterFormDetailsRecordHandle) {
    // 创建责任链build
    InvokeProxy.Build build = new InvokeProxy.Build();
    // 添加上下文handle
    build.addClassLoader(applicationContext.getClassLoader());
    // 添加登录认证handle、事务开启handle、流程任务处理handle
    build.addInvokeRequestFilter(principalHandle, transactionalHandle, processInstanceHandle);
    // 添加表单明细记录前处理handle，如果表单引擎模块为启用，则该handle可能为空，此handle必须在服务源调用handle之前
    if(beforeFormDetailsRecordHandle != null) build.addInvokeRequestFilter(beforeFormDetailsRecordHandle);
    // 添加服务源调用handle，如果表单引擎模块为启用，则该handle可能为空
    if(servicableInvokeHandle != null) build.addInvokeRequestFilter(servicableInvokeHandle);
    // 添加表单明细记录后处理handle，如果表单引擎模块为启用，则该handle可能为空，此handle必须在服务源调用handle之后
    if(afterFormDetailsRecordHandle != null) build.addInvokeResponseFilter(afterFormDetailsRecordHandle);
    // 添加静态表单实例详情日志更新handle、静态表单实例活动更新handle、返回处理handle
    build.addInvokeResponseFilter(staticInstanceDetailsLogUpdateHandle , staticInstanceActivityUpdateHandle , springMVCResponseHandle);
    return build.build();
  }

  /**
   * 获取一个操作流程任务代理器，注意，这个Bean限制了生命周期，那么每一个取得都将是一个新的执行代理器
   * @return
   */
  @Scope("prototype")
  @Bean("ProcessOperateServicableProxy")
  public InvokeProxy getProcessOperateServicableProxy(ApplicationContext applicationContext,
                                                          PrincipalHandle principalHandle,
                                                          TransactionalHandle transactionalHandle,
                                                          ProcessInstanceHandle processInstanceHandle,
                                                          SpringMVCResponseHandle springMVCResponseHandle) {
    InvokeProxy.Build build = new InvokeProxy.Build();
    build.addClassLoader(applicationContext.getClassLoader());
    build.addInvokeRequestFilter(principalHandle, transactionalHandle, processInstanceHandle);
    build.addInvokeResponseFilter(springMVCResponseHandle);
    return build.build();
  }

  /**
   * 获取一个“写”性质的动态表单操作代理器，注意，这个Bean限制了生命周期，那么每一个取得都将是一个新的执行代理器</br>
   * 这个代理器在什么情况下使用呢？在动态表单创建业务数据、修改业务数据时使用
   * @return
   */
  @Scope("prototype")
  @Bean("ProcessOperateAndDynamicFormWriteProxy")
  public InvokeProxy getProcessOperateAndDynamicFormWriteProxy(ApplicationContext applicationContext,
                                                               PrincipalHandle principalHandle,
                                                               TransactionalHandle transactionalHandle,
                                                               ProcessInstanceHandle processInstanceHandle,
                                                               @Qualifier("BeforeDynamicFormDetailsRecordHandle") DynamicFormDetailsRecordHandle beforeDynamicFormDetailsRecordHandle,
                                                               @Qualifier("AfterDynamicFormDetailsRecordHandle") DynamicFormDetailsRecordHandle afterDynamicFormDetailsRecordHandle,
                                                               DynamicFormSaveHandle dynamicFormSaveHandle,
                                                               DynamicInstanceDetailsLogUpdateHandle dynamicInstanceDetailsLogUpdateHandle,
                                                               DynamicInstanceActivityUpdateHandle dynamicInstanceActivityUpdateHandle,
                                                               SpringMVCResponseHandle springMVCResponseHandle) {
    // 创建责任链build
    InvokeProxy.Build build = new InvokeProxy.Build();
    // 添加上下文handle
    build.addClassLoader(applicationContext.getClassLoader());
    // 添加登录认证handle、事务开启handle、流程任务处理handle
    build.addInvokeRequestFilter(principalHandle , transactionalHandle, processInstanceHandle);
    // // 添加表单明细记录前处理handle，如果表单引擎模块为启用，则该handle可能为空，此handle必须在表单保存handle之前
    if(beforeDynamicFormDetailsRecordHandle != null) build.addInvokeRequestFilter(beforeDynamicFormDetailsRecordHandle);
    // 添加动态表单保存的handle，如果表单引擎模块为启用，则该handle可能为空
    if(dynamicFormSaveHandle != null) build.addInvokeRequestFilter(dynamicFormSaveHandle);
    // 添加表单明细记录后处理handle，如果表单引擎模块为启用，则该handle可能为空，此handle必须在动态表单保存的handle之后
    if(afterDynamicFormDetailsRecordHandle != null) build.addInvokeResponseFilter(afterDynamicFormDetailsRecordHandle);
    // 添加静态表单实例详情日志更新handle、静态表单实例活动更新handle、返回处理handle
    if(dynamicInstanceDetailsLogUpdateHandle != null) build.addInvokeResponseFilter(dynamicInstanceDetailsLogUpdateHandle);
    if(dynamicInstanceActivityUpdateHandle != null) build.addInvokeResponseFilter(dynamicInstanceActivityUpdateHandle);
    build.addInvokeResponseFilter(springMVCResponseHandle);
    return build.build();
  }


}
