package com.bizunited.platform.titan.starter.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.common.PlatformContext;

/**
 * 数据初始化配置，以保证流程引擎子系统在保证最小化数据完成性的基础上能够使用.
 * @author yinwenjie
 */
@Component("titan_systemInitConfig")
public class SystemInitConfig implements CommandLineRunner {
  @Autowired
  private PlatformContext platformContext;
  
  @Override
  public void run(String... args) throws Exception {
    platformContext.setEnableTitan(true);
  }
}
