package com.bizunited.platform.titan.starter.configuration;

import com.bizunited.platform.core.configuration.PlatformCoreConfig;
import com.bizunited.platform.titan.starter.configuration.flowable.FlowableJpaAutoConfiguration;
import com.bizunited.platform.titan.starter.configuration.flowable.ProcessEngineAutoConfiguration;
import com.bizunited.platform.titan.starter.service.TitanToolkitService;
import com.github.xiaoymin.swaggerbootstrapui.annotations.EnableSwaggerBootstrapUI;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-10 10:10
 * @Description:  使用该标识性质的注解，标记在业务工程的Service层，
 *     表示这个service可以通过流程引擎直接向表单模板开放
 */
@Configuration
@EnableAutoConfiguration
@ComponentScan(basePackages= {"com.bizunited.platform.titan" , "com.bizunited.platform.core"})
//启动swagger配置
@EnableSwagger2
@EnableSwaggerBootstrapUI
@Import({ProcessEngineAutoConfiguration.class, FlowableJpaAutoConfiguration.class , PlatformCoreConfig.class})
public class TitanServiceConfig {
  /**
   * 初始化流程引擎ID生成器
   * @return
   */
  @Bean
  public IdGenerator idGeneratorBean(){
    return new StrongUuidGenerator();
  }
  
  /**
   * 加载titan工作流的特定工具箱
   * @return
   */
  @Bean("TitanToolkitService")
  public TitanToolkitService getTitanToolkitService() {
    return new TitanToolkitService();
  }
}
