package com.bizunited.platform.titan.starter.configuration.flowable;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 流程引擎个模块的抽象配置类
 * @Author: Paul Chan
 * @Date: 2019-05-22 10:23
 */
public abstract class BaseEngineConfigurationWithConfigurers<T> {

  protected List<EngineConfigurationConfigurer<T>> engineConfigurers = new ArrayList<>();

  /**
   * 执行所有配置信息
   * @param engineConfiguration
   */
  protected void invokeConfigurers(T engineConfiguration) {
    engineConfigurers.forEach(configurer -> configurer.configure(engineConfiguration));
  }

  @Autowired(required = false)
  public void setEngineConfigurers(List<EngineConfigurationConfigurer<T>> engineConfigurers) {
    this.engineConfigurers = engineConfigurers;
  }

}
