package com.bizunited.platform.titan.starter.configuration.flowable;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-22 10:24
 * @Description: Interface to be implemented by a bean that does some extra configuration of a Flowable engines. If such a bean is defined, it will be called when the
 *  * specific engine configuration is created and the default values have been set.
 */
public interface EngineConfigurationConfigurer<T> {

  /**
   * Configure the provided engine. For example to provide a custom service implementation for a certain engine.
   */
  void configure(T engineConfiguration);

}
