package com.bizunited.platform.titan.starter.configuration.flowable;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 * Common configuration for engines that need the job executions setup.
 * @Author: Paul Chan
 * @Date: 2019-05-22 13:54
 */
@Configuration
public class FlowableJobConfiguration {

  /**
   * 任务执行器
   * @return
   */
  @Bean
  @ConditionalOnMissingBean
  public TaskExecutor taskExecutor() {
    ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
    executor.setCorePoolSize(2);
    executor.setMaxPoolSize(10);
    executor.setQueueCapacity(100);
    executor.setThreadNamePrefix("flowable-task-Executor-");
    executor.setAwaitTerminationSeconds(30);
    executor.setWaitForTasksToCompleteOnShutdown(true);
    executor.initialize();
    return executor;
  }

}
