package com.bizunited.platform.titan.starter.configuration.flowable;

import org.flowable.spring.SpringProcessEngineConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.persistence.EntityManagerFactory;

/**
 * Flowable的jpa自动配置
 * @Author: Paul Chan
 * @Date: 2019-05-22 11:29
 */
@Configuration
public class FlowableJpaAutoConfiguration {

  @Bean
  public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> jpaProcessEngineConfigurer(EntityManagerFactory emf) {
    return processEngineConfiguration -> {
      processEngineConfiguration.setJpaEntityManagerFactory(emf);
      processEngineConfiguration.setJpaHandleTransaction(false);
      processEngineConfiguration.setJpaCloseEntityManager(false);
    };
  }

}
