package com.bizunited.platform.titan.starter.configuration.flowable.process;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-22 10:39
 * @Description:
 */
@ConfigurationProperties(prefix = "titan.process")
public class FlowableProcessProperties {


  /**
   * Allow to override default history level for specific process definitions using the historyLevel extension element
   */
  protected boolean enableProcessDefinitionHistoryLevel = true;

  /**
   * The maximum amount of process definitions available in the process definition cache.
   * Per default it is 1 (all process definitions)
   */
  protected int definitionCacheLimit = -1;

  /**
   * Enables extra checks on the BPMN xml that is parsed. See https://www.flowable.org/docs/userguide/index.html#advanced.safe.bpmn.xml
   * Unfortunately, this feature is not available on some platforms (JDK 6, JBoss), hence you need to disable if your platform does not allow the use of
   * StaxSource during XML parsing.
   */
  private boolean enableSafeXml = true;


  public boolean isEnableProcessDefinitionHistoryLevel() {
    return enableProcessDefinitionHistoryLevel;
  }

  public void setEnableProcessDefinitionHistoryLevel(boolean enableProcessDefinitionHistoryLevel) {
    this.enableProcessDefinitionHistoryLevel = enableProcessDefinitionHistoryLevel;
  }

  public int getDefinitionCacheLimit() {
    return definitionCacheLimit;
  }

  public void setDefinitionCacheLimit(int definitionCacheLimit) {
    this.definitionCacheLimit = definitionCacheLimit;
  }

  public boolean isEnableSafeXml() {
    return enableSafeXml;
  }

  public void setEnableSafeXml(boolean enableSafeXml) {
    this.enableSafeXml = enableSafeXml;
  }

  public static class AsyncHistory {

    private boolean enabled;

    public boolean isEnabled() {
      return enabled;
    }

    public void setEnabled(boolean enabled) {
      this.enabled = enabled;
    }

  }


}
