package com.bizunited.platform.titan.starter.configuration.flowable.process;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-22 11:25
 * @Description: Qualifier annotation for a Process beans that need to be injected for Process Configurations.
 *  * <p>
 *  * This can be used when one wants to provide a dedicated {@link org.springframework.core.task.TaskExecutor} or
 *  * {@link org.flowable.spring.job.service.SpringRejectedJobsHandler} for the Process {@link org.flowable.spring.job.service.SpringAsyncExecutor}.
 *  *
 *  * <b>IMPORTANT:</b> When using this for the {@code TaskExecutor} or the {@code RejectedJobsHandler}, one needs to define a {@code @Primary} bean as well,
 *  * otherwise the CMMN Engine would use the one from the Process as well.
 */
public @interface Process {
}
