package com.bizunited.platform.titan.starter.configuration.flowable.process;

import org.springframework.beans.factory.annotation.Qualifier;

import java.lang.annotation.*;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-22 11:00
 * @Description: Qualifier annotation for beans that need to be injected for Process Configurations.
 *  * <p>
 *  * This can be used when one wants to provide a dedicated {@link org.flowable.spring.job.service.SpringAsyncHistoryExecutor} for the process engine.
 */
@Target({ ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE, ElementType.ANNOTATION_TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Qualifier
public @interface ProcessAsyncHistory {
}
