package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.entity.ProcessInstanceEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateEntity;
import com.bizunited.platform.titan.starter.service.ProcessCarbonCopyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.Date;

/**
 * 流程抄送功能业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @Author: Paul Chan
 * @Date: 2019-05-27 09:37
 */
@RestController
@Api(tags = "流程抄送功能业务模型的MVC Controller层实现")
@RequestMapping("v1/titan/carbonCopies")
public class ProcessCarbonCopyController extends BaseController {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessCarbonCopyController.class);

  @Autowired
  private ProcessCarbonCopyService processCarbonCopyService;

  /**
   * 条件分页查询我的抄送列表
   * @param pageable
   * @param formNo
   * @param submitDate
   * @param processKey
   * @param processName
   * @return
   */
  @GetMapping("findMyByConditions")
  @ApiOperation(value = "条件分页查询我的抄送列表", notes = "页数参数为page，第一页从0开始，分页大小参数为size（size默认为50）")
  public ResponseModel findMyByConditions(@PageableDefault(value = 50) Pageable pageable,
                                          @RequestParam(value = "formNo", required = false) @ApiParam(value = "表单编号") String formNo,
                                          @RequestParam(value = "submitDate", required = false) @ApiParam(value = "提交时间") @DateTimeFormat(pattern = "yyyy-MM-dd") Date submitDate,
                                          @RequestParam(value = "processKey", required = false) @ApiParam(value = "流程key") String processKey,
                                          @RequestParam(value = "processName", required = false) @ApiParam(value = "流程名称") String processName){
    try {
      Principal principal = this.getPrincipal(); 
      ProcessCarbonCopyEntity carbonCopy = new ProcessCarbonCopyEntity();
      ProcessInstanceEntity processInstance = new ProcessInstanceEntity();
      ProcessTemplateEntity processTemplate = new ProcessTemplateEntity();
      processTemplate.setProcessKey(processKey);
      processTemplate.setProcessName(processName);
      processInstance.setFormNo(formNo);
      processInstance.setLatestSubmitTime(submitDate);
      processInstance.setProcessTemplate(processTemplate);
      carbonCopy.setProcessInstance(processInstance);
      Page<ProcessCarbonCopyEntity> page = processCarbonCopyService.findMyByConditions(pageable, principal, carbonCopy);
      return buildHttpReslutW(page, "processInstance", "ccUser", "receiveAssignment", "processInstance.processTemplate", "processInstance.applicantUser");
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 阅读抄送信息
   * @param id
   * @return
   */
  @GetMapping("read")
  @ApiOperation(value = "阅读抄送信息")
  public ResponseModel read(@RequestParam("id") @ApiParam(value = "主键ID") String id){
    try {
      Principal principal = this.getPrincipal();
      processCarbonCopyService.read(id, principal);
      return buildHttpReslut();
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

}
