package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessCheckRecordEntity;
import com.bizunited.platform.titan.starter.service.ProcessCheckRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;
import java.util.Map;

/**
 * 流程检测功能业务模型的MVC Controller层实现
 * @Author: Paul Chan
 * @Date: 2019-06-17 14:47
 */
@RestController
@Api(tags = "流程检测功能业务模型的MVC Controller层实现")
@RequestMapping("v1/titan/process/checks")
public class ProcessCheckController extends BaseController {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessCheckController.class);

  @Autowired
  private ProcessCheckRecordService processCheckRecordService;

  /**
   * 流程检测
   * @param templateId
   * @param assignment
   * @param variables
   * @return
   */
  @PostMapping("")
  @ApiOperation(value = "流程检测")
  public ResponseModel checkProcess(@RequestParam("templateId") @ApiParam(value = "模版ID", required = true) String templateId,
                                    @RequestParam("assignment") @ApiParam(value = "发起人", required = true) String assignment,
                                    @RequestBody Map<String, Object> variables){
    try {
      Principal principal = this.getPrincipal();
      ProcessCheckRecordEntity record = processCheckRecordService.checkProcess(templateId, assignment, variables, principal);
      return buildHttpReslutW(record, "processCheckRecordItems", "createUser", "processTemplate");
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 根据模版ID查询流程检测记录
   * @param templateId
   * @return
   */
  @GetMapping("findByTemplateId")
  @ApiOperation(value = "根据模版ID查询流程检测记录")
  public ResponseModel findByTemplateId(@RequestParam("templateId") @ApiParam(value = "模版ID", required = true) String templateId){
    try {
      List<ProcessCheckRecordEntity> records = processCheckRecordService.findByTemplateId(templateId);
      return buildHttpReslutW(records);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 查询流程检测详情
   * @param id
   * @return
   */
  @GetMapping("findDetailById")
  @ApiOperation(value = "查询流程检测详情")
  public ResponseModel findDetailById(@RequestParam("id") @ApiParam(value = "ID", required = true) String id){
    try {
      ProcessCheckRecordEntity record = processCheckRecordService.findDetailById(id);
      return buildHttpReslutW(record, "processCheckRecordItems", "createUser", "processTemplate");
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

}
