package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessInstanceAttachmentEntity;
import com.bizunited.platform.titan.starter.service.ProcessInstanceAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.Set;

/**
 * 流程实例附件功能业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @Author: Paul Chan
 * @Date: 2019-06-10 14:13
 */
@Api(tags = "流程实例附件功能业务模型的MVC Controller层实现")
@RestController
@RequestMapping("v1/titan/instance/attachments")
public class ProcessInstanceAttachmentController extends BaseController {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceAttachmentController.class);

  @Autowired
  private ProcessInstanceAttachmentService processInstanceAttachmentService;

  /**
   * 保存附件信息
   * @param processInstanceId
   * @param attachments
   * @return
   */
  @PostMapping("")
  @ApiOperation(value = "保存附件信息")
  public ResponseModel create(@RequestParam(name = "processInstanceId") @ApiParam(value = "流程实例ID", required = true) String processInstanceId,
                            @RequestBody Set<ProcessInstanceAttachmentEntity> attachments){
    try {
      Principal principal = this.getPrincipal();
      Set<ProcessInstanceAttachmentEntity> attachmentEntities = processInstanceAttachmentService.create(processInstanceId, attachments, principal);
      return buildHttpReslutW(attachmentEntities, "ordinaryFile");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 根据ID删除附件信息
   * @param id
   * @return
   */
  @DeleteMapping("deleteById")
  @ApiOperation(value = "根据ID删除附件信息", notes = "这里的ID不是源文件的ID，是流程实例附件信息的ID")
  public ResponseModel deleteById(@RequestParam(name = "id") @ApiParam(value = "主键ID", required = true) String id){
    try {
      processInstanceAttachmentService.deleteById(id);
      return buildHttpReslut();
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }


}
