package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessInstanceMsgEntity;
import com.bizunited.platform.titan.starter.service.ProcessInstanceMsgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;

/**
 * 流程实例留言记录功能业务模型的MVC Controller层实现
 * @Author: Paul Chan
 * @Date: 2019-06-02 14:57
 */
@RestController
@RequestMapping("v1/titan/instance/msgs")
@Api(tags = "流程实例留言记录功能业务模型的MVC Controller层实现")
public class ProcessInstanceMsgController extends BaseController {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceMsgController.class);

  @Autowired
  private ProcessInstanceMsgService processInstanceMsgService;

  /**
   * 根据流程实例ID查询留言记录，根据留言时间顺序排序，以树形结构返回
   * @param processInstanceId
   * @return
   */
  @GetMapping("findByProcessInstanceId")
  @ApiOperation(value = "根据流程实例ID查询留言记录", notes = "根据留言时间顺序排序，以树形结构返回")
  public ResponseModel findByProcessInstanceId(@RequestParam("processInstanceId") @ApiParam(value = "流程实例ID", required = true) String processInstanceId){
    try {
      List<ProcessInstanceMsgEntity> msgs = processInstanceMsgService.findByProcessInstanceId(processInstanceId);
      ResponseModel responseModel = buildHttpReslut(msgs);
      return responseModel;
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 保存留言记录
   * @param msg
   * @return
   */
  @PostMapping("")
  @ApiOperation(value = "保存留言记录")
  public ResponseModel create(@RequestBody ProcessInstanceMsgEntity msg){
    try {
      Principal principal = this.getPrincipal();
      ProcessInstanceMsgEntity msgEntity = processInstanceMsgService.create(msg, principal);
      return buildHttpReslutW(msgEntity);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

}
