package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessInstanceOperateRecordEntity;
import com.bizunited.platform.titan.starter.service.ProcessInstanceOperateRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * 流程实例操作记录功能业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @Author: Paul Chan
 * @Date: 2019-05-27 17:04
 */
@Api(tags = "流程实例操作记录功能业务模型的MVC Controller层实现")
@RestController
@RequestMapping("v1/titan/instance/records")
public class ProcessInstanceOperateRecordController extends BaseController {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceOperateRecordController.class);

  @Autowired
  private ProcessInstanceOperateRecordService processInstanceOperateRecordService;

  /**
   * 根据流程实例ID查询操作信息,除了已执行的操作，还包括待执行的任务节点
   * @param processInstanceId
   * @return
   */
  @GetMapping("findDetailsByProcessInstanceId")
  @ApiOperation(value = "根据流程实例ID查询操作信息", notes = "除了已执行的操作，还包括待执行的任务节点")
  public ResponseModel findDetailsByProcessInstanceId(@RequestParam(name = "processInstanceId") @ApiParam(value = "流程实例ID") String processInstanceId){
    try {
      Set<ProcessInstanceOperateRecordEntity> records = processInstanceOperateRecordService.findDetailsByProcessInstanceId(processInstanceId);
      return buildHttpReslutW(records, "operator", "processTemplateNode");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

}
