package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.starter.service.ProcessListenerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-15 19:13
 * @Description: 流程监听器功能业务模型的MVC Controller层实现，基于HTTP Restful风格
 */
@RestController
@RequestMapping("v1/titan/listeners")
@Api(tags = "流程监听器功能业务模型的MVC Controller层实现")
public class ProcessListenerController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(ProcessListenerController.class);

  @Autowired
  private ProcessListenerService processListenerService;

  /**
   * 创建流程监听器
   * @param processListener
   * @return
   */
  @PostMapping("")
  @ApiOperation(value = "创建流程监听器")
  public ResponseModel create(@RequestBody ProcessListenerEntity processListener){
    try {
      processListener = processListenerService.create(processListener);
      return buildHttpReslutW(processListener);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 更新流程监听器
   * @param processListener
   * @return
   */
  @PatchMapping("")
  @ApiOperation(value = "更新流程监听器")
  public ResponseModel update(@RequestBody ProcessListenerEntity processListener){
    try {
      processListener = processListenerService.update(processListener);
      return buildHttpReslutW(processListener);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 切换状态
   * @param id
   * @param state
   * @return
   */
  @PatchMapping("/handleState")
  @ApiOperation(value = "切换状态")
  public ResponseModel handleState(@RequestParam(value = "id") @ApiParam(value = "ID", required = true) String id,
                                   @RequestParam(value = "state") @ApiParam(value = "状态：0=禁用1=启用", required = true) Integer state){
    try {
      processListenerService.handleState(id, state);
      return buildHttpReslut();
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 条件查询监听器
   * @param processListener
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "条件查询监听器")
  public ResponseModel findByConditions(@ApiParam("查询条件载体") ProcessListenerEntity processListener,
                                        @PageableDefault(value = 50) Pageable pageable){
    try {
      Page<ProcessListenerEntity> page = processListenerService.findByConditions(processListener, pageable);
      return buildHttpReslutW(page);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

}
