package com.bizunited.platform.titan.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.titan.entity.ProcessTemplateNodePermissionEntity;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodePermissionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;

/**
 * @Author: Paul Chan
 * @Date: 2019-05-21 17:40
 * @Description: 流程模版节点操作权限功能业务模型的MVC Controller层实现，基于HTTP Restful风格
 */
@Api(tags = "流程模版节点操作权限功能业务模型的MVC Controller层实现")
@RestController
@RequestMapping("v1/titan/template/node/permissions")
public class ProcessTemplateNodePermissionController extends BaseController {

  private final static Logger LOGGER = LoggerFactory.getLogger(ProcessTemplateNodePermissionController.class);

  @Autowired
  private ProcessTemplateNodePermissionService processTemplateNodePermissionService;

  /**
   * 分页查询流程模版节点操作权限
   * @param operateCode
   * @param pageable
   * @return
   */
  @GetMapping("findByConditions")
  @ApiOperation(value = "分页查询流程模版节点操作权限", notes = "页数参数为page，第一页从0开始，分页大小参数为size（size默认为50）")
  public ResponseModel findByConditions(@PageableDefault(value = 50) Pageable pageable,
                                        @ApiParam(value = "操作编码") @RequestParam(value = "operateCode", required = false) String operateCode,
                                        @ApiParam(value = "操作名称") @RequestParam(value = "operateName", required = false) String operateName){
    try {
      ProcessTemplateNodePermissionEntity nodePermission = new ProcessTemplateNodePermissionEntity();
      nodePermission.setOperateCode(operateCode);
      nodePermission.setOperateName(operateName);
      Page<ProcessTemplateNodePermissionEntity> page = processTemplateNodePermissionService.findByConditions(nodePermission, pageable);
      return buildHttpReslutW(page);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 创建节点操作权限
   * @param nodePermission
   * @return
   */
  @PostMapping("")
  @ApiOperation(value = "创建节点操作权限")
  public ResponseModel create(@RequestBody ProcessTemplateNodePermissionEntity nodePermission){
    try {
      Principal principal = this.getPrincipal();
      ProcessTemplateNodePermissionEntity nodePermissionEntity = processTemplateNodePermissionService.create(nodePermission, principal);
      return buildHttpReslutW(nodePermissionEntity);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  /**
   * 更新节点操作权限
   * @param nodePermission
   * @return
   */
  @PatchMapping("")
  @ApiOperation(value = "更新节点操作权限")
  public ResponseModel update(@RequestBody ProcessTemplateNodePermissionEntity nodePermission){
    try {
      Principal principal = this.getPrincipal();
      ProcessTemplateNodePermissionEntity nodePermissionEntity = processTemplateNodePermissionService.update(nodePermission, principal);
      return buildHttpReslutW(nodePermissionEntity);
    } catch (Exception e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

}
