package com.bizunited.platform.titan.starter.listener.proxy;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.titan.entity.ProcessListenerEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateListenerEntity;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import com.bizunited.platform.titan.starter.service.ProcessTemplateListenerService;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.ExecutionListenerNotifyHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.ExecutionScriptListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.response.ListenerResponseHandle;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;

/**
 * 执行监听器的代理监听器
 * 代理监听器会从流程模版中获取当前事件配置的监听器，并代理执行监听器的notify方法，代理器不处理异常信息，只负责调用
 * @Author: Paul Chan
 * @Date: 2019-05-23 16:46
 */
@Component("ExecutionProxyListener")
public class ExecutionProxyListener implements ExecutionListener {
  private static final long serialVersionUID = 6330718602637397814L;

  private final static Logger LOGGER = LoggerFactory.getLogger(ExecutionProxyListener.class);

  @Autowired
  private ScriptService scriptService;
  @Autowired
  private ApplicationContext applicationContext;
  @Autowired
  private PrincipalHandle principalHandle;
  @Autowired
  private TransactionalHandle transactionalHandle;
  @Autowired
  private ListenerResponseHandle listenerResponseHandle;
  @Autowired
  private ProcessTemplateListenerService processTemplateListenerService;

  @Override
  public void notify(DelegateExecution execution) {
    LOGGER.info("节点：{}", execution.getCurrentActivityId());
    LOGGER.info("EventName: {}", execution.getEventName());
    List<ProcessTemplateListenerEntity> listeners = processTemplateListenerService.findDetailsByProcessDefinitionIdAndTargetIdAndEvent(execution.getProcessDefinitionId(),
        execution.getCurrentActivityId(), execution.getEventName());
    if(!CollectionUtils.isEmpty(listeners)) {
      InvokeProxy.Build build = new InvokeProxy.Build();
      build.addClassLoader(applicationContext.getClassLoader());
      build.addInvokeRequestFilter(principalHandle, transactionalHandle);
      for (ProcessTemplateListenerEntity listener : listeners) {
        ProcessListenerEntity processListener = listener.getProcessListener();
        if(processListener.getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode())){
          // 处理原生监听器
          ExecutionListenerNotifyHandle handle = new ExecutionListenerNotifyHandle(execution, processListener, listener.getVariables());
          build.addInvokeRequestFilter(handle);
        } else if(processListener.getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())) {
          // 执行脚本监听器
          ExecutionScriptListenerHandle handle = new ExecutionScriptListenerHandle(listener.getScript(), execution, scriptService, listener.getVariables());
          build.addInvokeRequestFilter(handle);
        }
      }
      build.addInvokeResponseFilter(listenerResponseHandle);
      InvokeProxy invokeProxy = build.build();
      try {
        invokeProxy.doHandle(new HashMap<>(2));
      } catch (Exception e) {
        LOGGER.error(e.getMessage(), e);
        throw new IllegalArgumentException(e.getMessage(), e);
      }
    }
  }

}
