package com.bizunited.platform.titan.starter.listener.proxy;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.titan.entity.ProcessTemplateListenerEntity;
import com.bizunited.platform.titan.entity.ProcessTemplateNodeAssignmentEntity;
import com.bizunited.platform.titan.starter.common.enums.AssignmentType;
import com.bizunited.platform.titan.starter.common.enums.ProcessListenerExecuteMode;
import com.bizunited.platform.titan.starter.service.ProcessTemplateListenerService;
import com.bizunited.platform.titan.starter.service.ProcessTemplateNodeAssignmentService;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.TaskListenerNotifyHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.request.TaskScriptListenerHandle;
import com.bizunited.platform.titan.starter.service.invoke.handle.response.ListenerResponseHandle;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 任务监听器的代理监听器
 * 代理监听器会从流程模版中获取当前任务配置的舰艇器，并代理执行监听器的notify方法，代理器不处理异常信息，只负责调用
 * @Author: Paul Chan
 * @Date: 2019-05-23 16:33
 */
@Component("TaskProxyListener")
public class TaskProxyListener implements TaskListener {
  private static final long serialVersionUID = -7532614718969156854L;

  private final static Logger LOGGER = LoggerFactory.getLogger(TaskProxyListener.class);

  @Autowired
  private ScriptService scriptService;
  @Autowired
  private ApplicationContext applicationContext;
  @Autowired
  private PrincipalHandle principalHandle;
  @Autowired
  private TransactionalHandle transactionalHandle;
  @Autowired
  private ListenerResponseHandle listenerResponseHandle;
  @Autowired
  private ProcessTemplateListenerService processTemplateListenerService;
  @Autowired
  private ProcessTemplateNodeAssignmentService processTemplateNodeAssignmentService;

  @Override
  public void notify(DelegateTask delegateTask) {
    LOGGER.info("节点：{}", delegateTask.getTaskDefinitionKey());
    LOGGER.info("EventName: {}", delegateTask.getEventName());
    List<InvokeRequestHandle> handles = new ArrayList<>();
    if(delegateTask.getEventName().equals(EVENTNAME_CREATE)){
      // 如果是创建事件，则获取审批人配置，先一步执行寻人监听器
      ProcessTemplateNodeAssignmentEntity nodeAssignment = processTemplateNodeAssignmentService.findDetailsByProcessDefinitionIdAndProcessNodeId(delegateTask.getProcessDefinitionId(), delegateTask.getTaskDefinitionKey());
      if(nodeAssignment != null && nodeAssignment.getType().equals(AssignmentType.LISTENER.getType())) {
        if(nodeAssignment.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode())){
          // 添加原生监听器handle
          TaskListenerNotifyHandle handle = new TaskListenerNotifyHandle(delegateTask, nodeAssignment.getProcessListener(), nodeAssignment.getVariables());
          handles.add(handle);
        } else if (nodeAssignment.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())){
          // 添加脚本监听器handle
          TaskScriptListenerHandle handle = new TaskScriptListenerHandle(nodeAssignment.getScript(), delegateTask, scriptService, nodeAssignment.getVariables());
          handles.add(handle);
        }
      }
    }
    List<ProcessTemplateListenerEntity> listeners = processTemplateListenerService.findDetailsByProcessDefinitionIdAndTargetIdAndEvent(delegateTask.getProcessDefinitionId(),
        delegateTask.getTaskDefinitionKey(), delegateTask.getEventName());
    if(!CollectionUtils.isEmpty(listeners)) {
      for (ProcessTemplateListenerEntity listener : listeners) {
        if(listener.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.ORIGIN.getMode())){
          // 添加原生监听器handle
          TaskListenerNotifyHandle handle = new TaskListenerNotifyHandle(delegateTask, listener.getProcessListener(), listener.getVariables());
          handles.add(handle);
        } else if (listener.getProcessListener().getExecuteMode().equals(ProcessListenerExecuteMode.SCRIPT.getMode())){
          // 添加脚本监听器handle
          TaskScriptListenerHandle handle = new TaskScriptListenerHandle(listener.getScript(), delegateTask, scriptService, listener.getVariables());
          handles.add(handle);
        }
      }
    }
    if(!CollectionUtils.isEmpty(handles)){
      // 构建责任链并执行
      InvokeProxy.Build build = new InvokeProxy.Build();
      build.addClassLoader(applicationContext.getClassLoader());
      build.addInvokeRequestFilter(principalHandle, transactionalHandle);
      build.addInvokeRequestFilter(handles.toArray(new InvokeRequestHandle[handles.size()]));
      build.addInvokeResponseFilter(listenerResponseHandle);
      InvokeProxy invokeProxy = build.build();
      try {
        invokeProxy.doHandle(new HashMap<>(2));
      } catch (Exception e) {
        LOGGER.error(e.getMessage(), e);
        throw new IllegalArgumentException(e.getMessage(), e);
      }
    }
  }

}
