package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessAssignmentEntity;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * 流程审批人代理持久化接口
 * @Author: Paul Chan
 * @Date: 2019-05-31 10:41
 */
@Repository("ProcessAssignmentRepository")
public interface ProcessAssignmentRepository extends
    JpaRepository<ProcessAssignmentEntity, String>,
    JpaSpecificationExecutor<ProcessAssignmentEntity> {

  /**
   * 根据数据源ID查询
   * @param resourceId
   * @return
   */
  Set<ProcessAssignmentEntity> findByResourceId(String resourceId);

  /**
   * 根据数据源ID查询单个数据
   * @param resourceId
   * @return
   */
  @Query("select pa from ProcessAssignmentEntity pa where pa.resourceId = :resourceId")
  ProcessAssignmentEntity findOneByResourceId(@Param("resourceId") String resourceId);

  /**
   * 根据数据源ID删除
   * @param resourceId
   */
  @Modifying
  @Query("delete from ProcessAssignmentEntity pa where pa.resourceId = :resourceId")
  void deleteByResourceId(@Param("resourceId") String resourceId);

  /**
   * 根据数据源ID删除
   * @param resourceIds
   */
  @Modifying
  @Query("delete from ProcessAssignmentEntity pa where pa.resourceId = :resourceIds")
  void deleteByResourceIds(@Param("resourceIds") List<String> resourceIds);

  /**
   * 根据数据源ID查询,增加排序
   * @param resourceId
   * @param sort
   * @return
   */
  Set<ProcessAssignmentEntity> findByResourceId(String resourceId, Sort sort);

  /**
   * 根据数据源ID统计
   * @param resourceId
   * @return
   */
  @Query("select count(*) from ProcessAssignmentEntity pa where pa.resourceId = :resourceId")
  Long countByResourceId(@Param("resourceId") String resourceId);

}
