package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessCarbonCopyEntity;
import com.bizunited.platform.titan.starter.repository.internal.ProcessCarbonCopyRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 任务抄送的持久化接口
 * @Author: Paul Chan
 * @Date: 2019-05-24 15:56
 */
@Repository("ProcessCarbonCopyRepository")
public interface ProcessCarbonCopyRepository extends
    JpaRepository<ProcessCarbonCopyEntity, String>,
    JpaSpecificationExecutor<ProcessCarbonCopyEntity>,
    ProcessCarbonCopyRepositoryCustom {

  /**
   * 根据id查询抄送详情
   * @param id
   * @return
   */
  @Query("select pcc from ProcessCarbonCopyEntity pcc inner join fetch pcc.receiveAssignment pcco where pcc.id = :id")
  ProcessCarbonCopyEntity findDetailById(@Param("id") String id);

  /**
   * 根据用户ID和抄送人ID统计数量
   * @param taskId
   * @param assignment
   * @return
   */
  @Query("select count(*) from ProcessCarbonCopyEntity pcc inner join pcc.receiveAssignment pcca where pcc.taskId = :taskId and pcca.assignment = :assignment")
  Long countByTaskIdAndAssignment(@Param("taskId") String taskId, @Param("assignment") String assignment);
}
