package com.bizunited.platform.titan.starter.repository;

import com.bizunited.platform.titan.entity.ProcessCheckRecordEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 流程检测记录持久化
 * @Author: Paul Chan
 * @Date: 2019-06-17 15:04
 */
@Repository("ProcessCheckRecordRepository")
public interface ProcessCheckRecordRepository extends
    JpaRepository<ProcessCheckRecordEntity, String>,
    JpaSpecificationExecutor<ProcessCheckRecordEntity> {


  /**
   * 根据流程模版ID查询流程检测记录
   * @param templateId
   * @return
   */
  @Query("select pcr from ProcessCheckRecordEntity pcr inner join pcr.processTemplate pt where pt.id = :templateId order by pcr.createTime desc")
  List<ProcessCheckRecordEntity> findByTemplateId(@Param("templateId") String templateId);

  /**
   * 查询流程检测详情
   * @param id
   * @return
   */
  @Query("select pcr from ProcessCheckRecordEntity pcr inner join fetch pcr.processTemplate pt " +
      " inner join fetch pcr.createUser cu" +
      " left join fetch pcr.processCheckRecordItems pcri" +
      " where pcr.id = :id")
  ProcessCheckRecordEntity findDetailById(@Param("id") String id);
}
